/***************************************************************************
 * Copyright 2012 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.converter;

import javax.faces.convert.ConverterException;

import org.junit.Assert;
import org.junit.Test;

import kieker.webgui.domain.Role;

/**
 * Test class for {@link RoleStringConverter}.
 * 
 * @author Nils Christian Ehmke
 */
public class RoleStringConverterTest {

	/**
	 * Default constructor. <b>Do not use this constructor. This is just a test class and not to be used outside a JUnit test!</b>
	 */
	public RoleStringConverterTest() {
		// No code necessary
	}

	/**
	 * A test making sure that the {@code getAsString} method works correctly.
	 */
	@Test
	public void testEqualAsString() {
		final RoleStringConverter converter = new RoleStringConverter();

		Assert.assertEquals("Conversion failed.", Role.ADMINISTRATOR.toString(), converter.getAsString(null, null, Role.ADMINISTRATOR));
		Assert.assertEquals("Conversion failed.", Role.GUEST.toString(), converter.getAsString(null, null, Role.GUEST));
		Assert.assertEquals("Conversion failed.", Role.USER.toString(), converter.getAsString(null, null, Role.USER));
	}

	/**
	 * A test making sure that the {@code getAsObject} method works correctly.
	 */
	@Test
	public void testEqualFromString() {
		final RoleStringConverter converter = new RoleStringConverter();

		Assert.assertEquals("Conversion failed.", Role.ADMINISTRATOR, converter.getAsObject(null, null, Role.ADMINISTRATOR.toString()));
		Assert.assertEquals("Conversion failed.", Role.GUEST, converter.getAsObject(null, null, Role.GUEST.toString()));
		Assert.assertEquals("Conversion failed.", Role.USER, converter.getAsObject(null, null, Role.USER.toString()));
	}

	/**
	 * A test making sure that the methods of the converter handle null values correctly. This is specified by the API of the converter interface.
	 */
	@Test
	public void testNullHandling() {
		final RoleStringConverter converter = new RoleStringConverter();

		Assert.assertNull("Conversion failed.", converter.getAsObject(null, null, null));
		Assert.assertTrue("Conversion failed.", converter.getAsString(null, null, null).isEmpty());
	}

	/**
	 * A test making sure that the {@code getAsObject} method handles invalid values correctly. This is specified by the API of the converter interface.
	 */
	@Test
	public void testInvalidString() {
		final RoleStringConverter converter = new RoleStringConverter();

		try {
			converter.getAsObject(null, null, "");
			Assert.fail("Conversion failed.");
		} catch (final ConverterException ex) { // NOPMD (JUnit Test)
		}
	}

	/**
	 * A test making sure that the {@code getAsString} method handles invalid values correctly. This is specified by the API of the converter interface.
	 */
	@Test
	public void testInvalidObject() {
		final RoleStringConverter converter = new RoleStringConverter();

		try {
			converter.getAsString(null, null, new Object());
			Assert.fail("Conversion failed.");
		} catch (final ConverterException ex) { // NOPMD (JUnit Test)
		}

	}
}
