/***************************************************************************
 * Copyright 2012 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.service.impl;

import org.junit.Assert;
import org.junit.Test;

import kieker.webgui.common.exception.GraphLayoutException;
import kieker.webgui.service.IGraphLayoutService;

/**
 * Test class for {@link KielerGraphLayoutServiceImpl}.
 * 
 * @author Nils Christian Ehmke
 */
public class GraphLayoutServiceImplTest {

	/**
	 * Default constructor. <b>Do not use this constructor. This is just a test class and not to be used outside a JUnit test!</b>
	 */
	public GraphLayoutServiceImplTest() {
		// No code necessary
	}

	/**
	 * A test making sure that an invalid node/edge combination results in an exceptions.
	 */
	@Test
	public void testLayoutFail() {
		final IGraphLayoutService layouter = new KielerGraphLayoutServiceImpl();

		try {
			layouter.layoutGraph("", "");
			Assert.fail("Graph layouting failed");
		} catch (final GraphLayoutException ex) { // NOPMD (JUnit Test)
		}
	}

	/**
	 * A test making sure that the layout works for nodes without edges.
	 * 
	 * @throws GraphLayoutException
	 *             If something went wrong.
	 */
	@Test
	public void testLayoutWithoutEdges() throws GraphLayoutException {
		final IGraphLayoutService layouter = new KielerGraphLayoutServiceImpl();

		final String inputNodes = "12;0 -1 204 72 f 0 0 0 0 1 78;1 -1 216 84 f 1 90 0 0 2 78";
		final String inputEdges = "";

		// We assert that the layout method succeeds
		final String layoutString = layouter.layoutGraph(inputNodes, inputEdges);
		Assert.assertTrue("Graph layouting failed", layoutString.startsWith("autoLayout#"));
	}

	/**
	 * A test making sure that the layout works for nodes with edges.
	 * 
	 * @throws GraphLayoutException
	 *             If something went wrong.
	 */
	@Test
	public void testLayoutWithEdges() throws GraphLayoutException {
		final IGraphLayoutService layouter = new KielerGraphLayoutServiceImpl();

		final String inputNodes = "12;0 -1 204 72 f 0 0 0 0 1 78;1 -1 216 84 f 1 90 0 0 2 78";
		final String inputEdges = "0 0 1 0";

		// We assert that the layout method succeeds
		final String layoutString = layouter.layoutGraph(inputNodes, inputEdges);
		Assert.assertTrue("Graph layouting failed", layoutString.startsWith("autoLayout#"));
	}
}
