/***************************************************************************
 * Copyright 2012 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.persistence.impl.utility;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;

import org.junit.Assert;
import org.junit.Test;

import kieker.webgui.common.ClassContainer;
import kieker.webgui.common.exception.ReflectionException;

/**
 * Test class for {@link PluginFinder}.
 * 
 * @author Nils Christian Ehmke
 */
public class PluginFinderTest {

	private static final String KIEKER_LIB = "kieker.jar";

	/**
	 * Default constructor. <b>Do not use this constructor. This is just a test class and not to be used outside a JUnit test!</b>
	 */
	public PluginFinderTest() {
		// No code necessary
	}

	/**
	 * A test making sure that the kieker plugins are available.
	 * 
	 * @throws ReflectionException
	 *             If something went wrong.
	 * @throws IOException
	 *             If something went wrong.
	 */
	@Test
	public void testKiekerPlugins() throws ReflectionException, IOException {
		final PluginFinder pluginFinder = new PluginFinder();
		final URL kiekerURL = Thread.currentThread().getContextClassLoader().getResource(PluginFinderTest.KIEKER_LIB);
		final CloseableURLClassLoader classLoader = new CloseableURLClassLoader(new URL[] { kiekerURL });
		final ClassContainer classAndMethodContainer = new ClassContainer(classLoader);

		final Collection<Class<?>> filters = pluginFinder.getAllFiltersWithinJar(kiekerURL, classLoader, classAndMethodContainer);
		final Collection<Class<?>> readers = pluginFinder.getAllReadersWithinJar(kiekerURL, classLoader, classAndMethodContainer);
		final Collection<Class<?>> repositories = pluginFinder.getAllRepositoriesWithinJar(kiekerURL, classLoader, classAndMethodContainer);

		// There should be at least one element of both types
		Assert.assertFalse("No filters found.", filters.isEmpty());
		Assert.assertFalse("No readers found.", readers.isEmpty());
		Assert.assertFalse("No repositories found.", repositories.isEmpty());

		classLoader.close();
	}

}
