/***************************************************************************
 * Copyright 2012 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.common;

import org.junit.Assert;
import org.junit.Test;

/**
 * Test class for {@link EnvironmentLoaderListener}.
 * 
 * @author Nils Christian Ehmke
 */
public class EnvironmentLoaderListenerTest {

	/**
	 * Default constructor. <b>Do not use this constructor. This is just a test class and not to be used outside a JUnit test!</b>
	 */
	public EnvironmentLoaderListenerTest() {
		// No code necessary
	}

	/**
	 * A test of this test class.
	 */
	@Test
	public void testSystemPropertySet() {
		final EnvironmentLoaderListener listener = new EnvironmentLoaderListener();
		Assert.assertNull("System property already set.", System.getProperty("kieker.common.logging.Log"));
		listener.contextInitialized(null);
		Assert.assertEquals("System property not set.", "WEBGUI", System.getProperty("kieker.common.logging.Log"));
	}

}
