/***************************************************************************
 * Copyright 2012 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.common;

import java.io.IOException;
import java.net.URL;

import org.junit.Assert;
import org.junit.Test;

import kieker.webgui.common.exception.ReflectionException;
import kieker.webgui.persistence.impl.utility.CloseableURLClassLoader;

/**
 * Test class for {@link ClassContainer}.
 * 
 * @author Nils Christian Ehmke
 */
public class ClassAndMethodContainerTest {

	private static final String KIEKER_LIB = "kieker.jar";

	/**
	 * Default constructor. <b>Do not use this constructor. This is just a test class and not to be used outside a JUnit test!</b>
	 */
	public ClassAndMethodContainerTest() {
		// No code necessary
	}

	/**
	 * A test of this test class.
	 */
	@Test
	public void testKiekerAvailable() {
		final URL kiekerURL = Thread.currentThread().getContextClassLoader().getResource(ClassAndMethodContainerTest.KIEKER_LIB);
		final CloseableURLClassLoader classLoader = new CloseableURLClassLoader(new URL[] { kiekerURL });

		// If this fails, we know that kieker is not available here
		try {
			new ClassContainer(classLoader);
		} catch (final ReflectionException ex) {
			Assert.fail("Kieker dependency not available.");
		}

		try {
			classLoader.close();
		} catch (final IOException ex) {
			Assert.fail("An exception occured while closing the classloader.");
		}
	}

}
