/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.utility.displaySettings;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/**
 * This is a settings container for a line chart within the cockpit.
 * 
 * @author Nils Christian Ehmke
 */
public final class XYPlotDisplaySettings implements IDisplayConnectorSettings {

	private Map<String, String> availablePlots = Collections.emptyMap();
	private Collection<String> visiblePlots = Collections.emptyList();
	private boolean usingShadows = true;
	private boolean usingFilledChart;
	private boolean usingStackedCharts;
	private boolean usingVisibleLegend = true;
	private boolean usePoints = true;

	/**
	 * Creates a new instance of this class.
	 */
	public XYPlotDisplaySettings() {
		// No code necessary
	}

	public boolean isUsingShadows() {
		return this.usingShadows;
	}

	public void setUsingShadows(final boolean usingShadows) {
		this.usingShadows = usingShadows;
	}

	public boolean isUsingFilledChart() {
		return this.usingFilledChart;
	}

	public void setUsingFilledChart(final boolean usingFilledChart) {
		this.usingFilledChart = usingFilledChart;
	}

	public boolean isUsingStackedCharts() {
		return this.usingStackedCharts;
	}

	public void setUsingStackedCharts(final boolean usingStackedCharts) {
		this.usingStackedCharts = usingStackedCharts;
	}

	public boolean isUsingVisibleLegend() {
		return this.usingVisibleLegend;
	}

	public void setUsingVisibleLegend(final boolean usingVisibleLegend) {
		this.usingVisibleLegend = usingVisibleLegend;
	}

	public boolean isUsePoints() {
		return this.usePoints;
	}

	public void setUsePoints(final boolean usePoints) {
		this.usePoints = usePoints;
	}

	public Collection<String> getVisiblePlots() {
		return this.visiblePlots;
	}

	public void setVisiblePlots(final Collection<String> visiblePlots) {
		this.visiblePlots = visiblePlots;
	}

	public Map<String, String> getAvailablePlots() {
		return this.availablePlots;
	}

	public void setAvailablePlots(final Map<String, String> availablePlots) {
		this.availablePlots = availablePlots;
	}

}
