/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.utility.displaySettings;

/**
 * This is a settings container for a pie chart within the cockpit.
 * 
 * @author Nils Christian Ehmke
 */
public final class PieChartDisplaySettings implements IDisplayConnectorSettings {

	private boolean usingShadows = true;
	private boolean usingFilledChart;
	private boolean usingVisibleDataLabels = true;
	private boolean usingVisibleLegend = true;

	/**
	 * Creates a new instance of this class.
	 */
	public PieChartDisplaySettings() {
		// No code necessary
	}

	public boolean isUsingShadows() {
		return this.usingShadows;
	}

	public void setUsingShadows(final boolean usingShadows) {
		this.usingShadows = usingShadows;
	}

	public boolean isUsingFilledChart() {
		return this.usingFilledChart;
	}

	public void setUsingFilledChart(final boolean usingFilledChart) {
		this.usingFilledChart = usingFilledChart;
	}

	public boolean isUsingVisibleDataLabels() {
		return this.usingVisibleDataLabels;
	}

	public void setUsingVisibleDataLabels(final boolean usingVisibleDataLabels) {
		this.usingVisibleDataLabels = usingVisibleDataLabels;
	}

	public boolean isUsingVisibleLegend() {
		return this.usingVisibleLegend;
	}

	public void setUsingVisibleLegend(final boolean usingVisibleLegend) {
		this.usingVisibleLegend = usingVisibleLegend;
	}

}
