/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.utility.displaySettings;

import java.util.Collections;
import java.util.Map;

/**
 * This is a settings container for a meter gauge within the cockpit.
 * 
 * @author Nils Christian Ehmke
 */
public final class MeterGaugeDisplaySettings implements IDisplayConnectorSettings {

	private Map<String, String> availablePlots = Collections.emptyMap();
	private String visiblePlot = "";

	/**
	 * Creates a new instance of this class.
	 */
	public MeterGaugeDisplaySettings() {
		// No code necessary
	}

	public Map<String, String> getAvailablePlots() {
		return this.availablePlots;
	}

	public void setAvailablePlots(final Map<String, String> availablePlots) {
		this.availablePlots = availablePlots;
	}

	public String getVisiblePlot() {
		return this.visiblePlot;
	}

	public void setVisiblePlot(final String visiblePlot) {
		this.visiblePlot = visiblePlot;
	}

}
