/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.utility.command;

import kieker.analysis.model.analysisMetaModel.MIFilter;
import kieker.analysis.model.analysisMetaModel.MIPlugin;
import kieker.analysis.model.analysisMetaModel.MIProject;
import kieker.analysis.model.analysisMetaModel.MIReader;
import kieker.webgui.web.beans.view.AnalysisEditorGraphBean;

/**
 * @author Nils Christian Ehmke
 */
public final class AddPluginCommand extends AbstractEditorCommand {

	private final MIProject parent;
	private final MIPlugin plugin;
	private final AnalysisEditorGraphBean graphBean;

	/**
	 * Creates a new instance of this class using the given parameters.
	 * 
	 * @param parent
	 *            The parent project in which a plugin should be added.
	 * @param plugin
	 *            The plugin which should be added.
	 * @param graphBean
	 *            The corresponding graph bean.
	 */
	public AddPluginCommand(final MIProject parent, final MIPlugin plugin, final AnalysisEditorGraphBean graphBean) {
		this.parent = parent;
		this.plugin = plugin;
		this.graphBean = graphBean;
	}

	@Override
	public void execute() {
		this.parent.getPlugins().add(this.plugin);
		if (this.plugin instanceof MIFilter) {
			this.graphBean.addComponent((MIFilter) this.plugin);
		} else {
			this.graphBean.addComponent((MIReader) this.plugin);
		}
	}

	@Override
	public AbstractEditorCommand invert() {
		return new DeletePluginCommand(this.parent, this.plugin, this.graphBean);
	}

}
