/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.utility.command;

/**
 * This is the abstract base for all other editor commands within this application.
 * 
 * @author Nils Christian Ehmke
 */
public abstract class AbstractEditorCommand {

	/**
	 * Creates a new instance of this class.
	 */
	public AbstractEditorCommand() {
		// No code necessary
	}

	/**
	 * Executes this command.
	 */
	public abstract void execute();

	/**
	 * Inverts this command.
	 * 
	 * @return The inverted command.
	 */
	public abstract AbstractEditorCommand invert();

}
