/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.utility;

import kieker.analysis.model.analysisMetaModel.MIAnalysisComponent;
import kieker.analysis.model.analysisMetaModel.MIInputPort;
import kieker.analysis.model.analysisMetaModel.MIOutputPort;
import kieker.analysis.model.analysisMetaModel.MIRepository;
import kieker.analysis.model.analysisMetaModel.MIRepositoryConnector;

/**
 * This interface should be implemented by classes, which are observing a graph. The listeners are informed about events within the graph.
 * 
 * @author Nils Christian Ehmke
 */
public interface IGraphListener {

	/**
	 * An event occurring when a component has been selected.
	 * 
	 * @param selectedComponent
	 *            The selected component.
	 */
	public void componentSelectedEvent(MIAnalysisComponent selectedComponent);

	/**
	 * An event occurring when a component has been deleted.
	 * 
	 * @param deletedComponent
	 *            The deleted component.
	 */
	public void componentDeletedEvent(final MIAnalysisComponent deletedComponent);

	/**
	 * An event occurring when a connection has been created.
	 * 
	 * @param sourcePort
	 *            The source port.
	 * @param targetRepo
	 *            The target.
	 */
	public void connectionAddedEvent(MIRepositoryConnector sourcePort, MIRepository targetRepo);

	/**
	 * An event occurring when a connection has been created.
	 * 
	 * @param sourcePort
	 *            The source port.
	 * @param targetPort
	 *            The target port.
	 */
	public void connectionAddedEvent(MIOutputPort sourcePort, MIInputPort targetPort);

	/**
	 * An event occurring when a connection has been deleted.
	 * 
	 * @param sourcePort
	 *            The source port.
	 * @param targetRepo
	 *            The target.
	 */
	public void connectionDeletedEvent(MIRepositoryConnector sourcePort, MIRepository targetRepo);

	/**
	 * An event occurring when a connection has been deleted.
	 * 
	 * @param sourcePort
	 *            The source port.
	 * @param targetPort
	 *            The target port.
	 */
	public void connectionDeletedEvent(MIOutputPort sourcePort, MIInputPort targetPort);

}
