/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.beans.request.view;

import javax.annotation.PostConstruct;
import javax.faces.component.UIComponent;

import kieker.webgui.web.beans.application.GlobalPropertiesBean;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * This is the abstract base for the other request scoped view beans.
 * 
 * @author Nils Christian Ehmke
 */
public abstract class AbstractViewBean {

	private String viewName;
	private String viewDescription;
	private UIComponent messageTarget;

	@Autowired
	private GlobalPropertiesBean globalPropertiesBean;

	/**
	 * Default constructor.
	 */
	public AbstractViewBean() {
		// No code necessary
	}

	/**
	 * This method initializes the object. <b>Do not call this method manually. It will only be accessed by Spring.</b>
	 */
	@PostConstruct
	public void initialize() {
		// We initialize the fields with localized default values
		this.viewName = this.globalPropertiesBean.getDefaultViewName();
		this.viewDescription = this.globalPropertiesBean.getDefaultViewDescription();
	}

	public String getViewName() {
		return this.viewName;
	}

	public void setViewName(final String projectName) {
		this.viewName = projectName;
	}

	public String getViewDescription() {
		return this.viewDescription;
	}

	public void setViewDescription(final String viewDescription) {
		this.viewDescription = viewDescription;
	}

	public UIComponent getMessageTarget() {
		return this.messageTarget;
	}

	public void setMessageTarget(final UIComponent messageTarget) {
		this.messageTarget = messageTarget;
	}

}
