/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.beans.request.user;

import javax.faces.component.UIComponent;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * This simple {@code Spring} managed bean is request scoped and can be used to store the necessary data for a new user during a request. It should not be used, for
 * example, to deliver a list containing the available user within the system. For such cases you should use {@link kieker.webgui.domain.User} instead.
 * 
 * @author Nils Christian Ehmke
 */
@Component
@Scope("request")
public final class NewUserBean extends AbstractUserBean {

	private String password;
	private UIComponent messageTarget;

	/**
	 * Creates a new instance of this bean and initializes it with default values. <b>Do not use this constructor. This bean is Spring managed.</b>
	 */
	public NewUserBean() {
		this.password = "";
	}

	public String getPassword() {
		return this.password;
	}

	public void setPassword(final String password) {
		this.password = password;
	}

	public UIComponent getMessageTarget() {
		return this.messageTarget;
	}

	public void setMessageTarget(final UIComponent messageTarget) {
		this.messageTarget = messageTarget;
	}

}
