/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.beans.request.user;

import javax.annotation.PostConstruct;

import kieker.webgui.domain.Role;
import kieker.webgui.web.beans.application.GlobalPropertiesBean;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * This is the abstract base for the other request scoped user beans.
 * 
 * @author Nils Christian Ehmke
 */
public abstract class AbstractUserBean {

	private Role role;
	private String username;
	private boolean active;

	@Autowired
	private GlobalPropertiesBean globalPropertiesBean;

	/**
	 * Default constructor.
	 */
	public AbstractUserBean() {
		this.role = Role.GUEST;
		this.active = false;
	}

	/**
	 * This method initializes some fields of the object. <b>Do not call this method manually. It will only be accessed by Spring.</b>
	 */
	@PostConstruct
	public void initialize() {
		// We initialize the remaining fields with localized default values
		this.username = this.globalPropertiesBean.getDefaultUserName();
	}

	public Role getRole() {
		return this.role;
	}

	public void setRole(final Role role) {
		this.role = role;
	}

	public String getUsername() {
		return this.username;
	}

	public void setUsername(final String username) {
		this.username = username;
	}

	public boolean isActive() {
		return this.active;
	}

	public void setActive(final boolean active) {
		this.active = active;
	}
}
