/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.web.beans.request.project;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * This class is a request scoped {@code Spring} bean to store the properties of a project during a single request. It can be used to copy an existing project.
 * 
 * @author Nils Christian Ehmke
 */
@Component
@Scope("request")
public final class CopyProjectBean extends AbstractProjectBean {

	/**
	 * Creates a new instance of this class. <b>Do not call this constructor manually. It will only be accessed by Spring.</b>
	 */
	public CopyProjectBean() {
		super();
	}

}
