/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.service.impl.utility.model;

import kieker.webgui.service.impl.utility.KielerInterface;

import de.cau.cs.kieler.core.kgraph.KPort;

/**
 * Objects of this class represent a single Port of a {@link Node}. A {@link KPort} is referenced
 * and is used for the Kieler layout algorithm.
 * 
 * @author Robin Weiss, Florian Fittkau
 * 
 */
public class Port {

	private final KPort kielerPort;
	private final int index;

	/**
	 * Constructor for {@link Port}. Assigns the {@link Port} to a {@link Node} and creates a {@link KPort} out of the given information.
	 * 
	 * @param graph
	 *            the {@link Graph} to which the node belongs
	 * @param node
	 *            the {@link Node} to which the {@link Port} belongs
	 * @param index
	 *            an integer used for distinguishing ports of a {@link Node}
	 * @param x
	 *            the x-position of the port, relative to the left border of the node
	 * @param y
	 *            the y-position of the port, relative to the top border of the node
	 */
	public Port(final Graph graph, final Node node, final int index, final int x, final int y) {
		this.index = index;
		this.kielerPort = KielerInterface.makeKielerPort(graph, node, x, y);
	}

	public KPort getKielerPort() {
		return this.kielerPort;
	}

	public int getIndex() {
		return this.index;
	}

}
