/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.service.impl.utility.model;

/**
 * A simple 2-dimensional integer point, used for storing positions of any relevant graph component.
 * 
 * @author Robin Weiss, Florian Fittkau
 * 
 */
public class Point {
	private int xValue;
	private int yValue;

	/**
	 * Simple constructor, initializing both dimensions with zero.
	 */
	public Point() {
		this.xValue = 0;
		this.yValue = 0;
	}

	/**
	 * A constructor that rounds float values to the internal integer representation.
	 * 
	 * @param x
	 *            the unrounded x-coordinate
	 * @param y
	 *            the unrounded y-coordinate
	 */
	public Point(final float x, final float y) {
		this.xValue = Math.round(x);
		this.yValue = Math.round(y);
	}

	/**
	 * A constructor that takes integer values for the coordinates.
	 * 
	 * @param x
	 *            the x-coordinate
	 * @param y
	 *            the y-coordinate
	 */
	public Point(final int x, final int y) {
		this.xValue = x;
		this.yValue = y;
	}

	/**
	 * @return the x-coordinate of the {@link Point}
	 */
	public int getX() {
		return this.xValue;
	}

	/**
	 * @return the y-coordinate of the {@link Point}
	 */
	public int getY() {
		return this.yValue;
	}

	/**
	 * Rounds two float values and stores the rounded integer
	 * values as new coordinates.
	 * 
	 * @param x
	 *            the unrounded x-coordinate
	 * @param y
	 *            the unrounded y-coordinate
	 */
	public void setValue(final float x, final float y) {
		this.xValue = Math.round(x);
		this.yValue = Math.round(y);
	}

	/**
	 * Stores two integer values as new coordinates.
	 * 
	 * @param x
	 *            the x-coordinate
	 * @param y
	 *            the y-coordinate
	 */
	public void setValue(final int x, final int y) {
		this.xValue = x;
		this.yValue = y;
	}
}
