/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/
package kieker.webgui.service.impl;

import java.util.List;

import kieker.webgui.common.exception.DataAccessException;
import kieker.webgui.domain.User;
import kieker.webgui.persistence.IUserDAO;
import kieker.webgui.service.IUserService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * This is an implementation of the {@link IUserService} interface. The work is delegated to the underlying data access object.
 * 
 * @author Nils Christian Ehmke
 */
@Service
public final class UserServiceImpl implements IUserService {

	@Autowired
	private IUserDAO userDAO;

	/**
	 * Default constructor. <b>Do not use this constructor. This bean is Spring managed.</b>
	 */
	public UserServiceImpl() {
		// No code necessary
	}

	@Override
	public void addUser(final User user) throws DataAccessException {
		this.userDAO.addUser(user);
	}

	@Override
	public List<User> getUsers() throws DataAccessException {
		return this.userDAO.getUsers();
	}

	@Override
	public void deleteUser(final User user) throws DataAccessException {
		this.userDAO.deleteUser(user);
	}

	@Override
	public void editUserWithoutPassword(final User user) throws DataAccessException {
		this.userDAO.editUserWithoutPassword(user);
	}

	@Override
	public void editUserWithPassword(final User user) throws DataAccessException {
		this.userDAO.editUserWithPassword(user);
	}

}
