/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.service;

import kieker.webgui.common.exception.GraphLayoutException;

import org.springframework.security.access.prepost.PreAuthorize;

/**
 * This is the interface for a service providing a graph layouter. The methods within this service can be accessed by every authenticated user.
 * 
 * @author Nils Christian Ehmke
 */
public interface IGraphLayoutService {

	/**
	 * This method interprets the two given strings as a graph and performs an auto layout.
	 * 
	 * @param nodes
	 *            A string containing the node information of the graph.
	 * @param edges
	 *            A string containing the edge information of the graph.
	 * 
	 * @return A layout string for the graph.
	 * 
	 * @throws GraphLayoutException
	 *             If the auto layout failed.
	 */
	@PreAuthorize("isAuthenticated()")
	public String layoutGraph(String nodes, String edges) throws GraphLayoutException;

}
