/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.domain.pluginDecorators;

import java.util.Map;

import kieker.analysis.model.analysisMetaModel.MIReader;

/**
 * This is the actual decorator which decorates an {@link MIReader} instance with some more properties and methods. The already existing behavior of the
 * {@link MIReader} instance is not modified.
 * 
 * @author Nils Christian Ehmke
 */
public final class ReaderDecorator extends AbstractPluginDecorator<MIReader> implements MIReader {

	/**
	 * Constructor to instantiate the fields of this class.
	 * 
	 * @param analysisComponent
	 *            The component wrapped by this decorator.
	 * @param propertiesDescriptions
	 *            The descriptions of the properties.
	 * @param description
	 *            The description of the wrapped component.
	 * @param dependency
	 *            The dependency description of the wrapped component.
	 * @param fullyInitialized
	 *            A flag to show whether the component has been fully initialized or not.
	 * @param displaysDescriptions
	 *            The descriptions of the displays.
	 */
	public ReaderDecorator(final MIReader analysisComponent, final Map<String, String> propertiesDescriptions, final String description, final String dependency,
			final boolean fullyInitialized, final Map<String, String> displaysDescriptions) {
		super(analysisComponent, propertiesDescriptions, description, dependency, fullyInitialized, displaysDescriptions);
	}

	@Override
	protected final MIReader createComponent() {
		return FACTORY.createReader();
	}

}
