/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.domain.pluginDecorators;

import java.util.Map;

import kieker.analysis.model.analysisMetaModel.MIFilter;
import kieker.analysis.model.analysisMetaModel.MIInputPort;

import org.eclipse.emf.common.util.EList;

/**
 * This is the actual decorator which decorates an {@link MIFilter} instance with some more properties and methods. The already existing behavior of the
 * {@link MIFilter} instance is not modified.
 * 
 * @author Nils Christian Ehmke
 */
public class FilterDecorator extends AbstractPluginDecorator<MIFilter> implements MIFilter {

	/**
	 * Constructor to instantiate the fields of this class.
	 * 
	 * @param analysisComponent
	 *            The component wrapped by this decorator.
	 * @param propertiesDescriptions
	 *            The descriptions of the properties.
	 * @param description
	 *            The description of the wrapped component.
	 * @param dependency
	 *            The dependency description of the wrapped component.
	 * @param fullyInitialized
	 *            A flag to show whether the component has been fully initialized or not.
	 * @param displaysDescriptions
	 *            The descriptions of the displays.
	 */
	public FilterDecorator(final MIFilter analysisComponent, final Map<String, String> propertiesDescriptions, final String description, final String dependency,
			final boolean fullyInitialized, final Map<String, String> displaysDescriptions) {
		super(analysisComponent, propertiesDescriptions, description, dependency, fullyInitialized, displaysDescriptions);
	}

	@Override
	protected final MIFilter createComponent() {
		return FACTORY.createFilter();
	}

	@Override
	protected final void refineComponentCopy(final MIFilter componentCopy) {
		super.refineComponentCopy(componentCopy);

		// Copy the input ports of the plugin instance
		for (final MIInputPort inputPort : super.analysisComponent.getInputPorts()) {
			final MIInputPort inputPortCopy = FACTORY.createInputPort();
			inputPortCopy.setName(inputPort.getName());
			inputPortCopy.setParent(componentCopy);
			componentCopy.getInputPorts().add(inputPortCopy);
		}
	}

	@Override
	public final EList<MIInputPort> getInputPorts() {
		return super.analysisComponent.getInputPorts();
	}

}
