/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.domain;

/**
 * This is a domain object representing a user within the system.
 * 
 * @author Nils Christian Ehmke
 */
public final class User {

	private String name;
	private String password;
	private Role role;
	private boolean enabled;

	/**
	 * Creates a new user with the given parameters. The user will not be saved within the data base though.
	 * 
	 * @param name
	 *            The name of the user.
	 * @param password
	 *            The password of the user.
	 * @param role
	 *            The role of the user.
	 * @param enabled
	 *            A flag whether the user is enabled or not.
	 */
	public User(final String name, final String password, final Role role, final boolean enabled) {
		this.name = name;
		this.role = role;
		this.enabled = enabled;
		this.password = password;
	}

	/**
	 * Delivers a copy of this user, but with empty password field.
	 * 
	 * @return A copy of this instance.
	 */
	public User copy() {
		return new User(this.name, null, this.role, this.isEnabled());
	}

	public String getName() {
		return this.name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getPassword() {
		return this.password;
	}

	public void setPassword(final String password) {
		this.password = password;
	}

	public Role getRole() {
		return this.role;
	}

	public void setRole(final Role role) {
		this.role = role;
	}

	public boolean isEnabled() {
		return this.enabled;
	}

	public void setEnabled(final boolean enabled) {
		this.enabled = enabled;
	}

}
