/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.domain;

/**
 * This enumeration represents the different display types within Kieker.
 * 
 * @author Nils Christian Ehmke
 */
public enum DisplayType {

	/** Represents the plot display type. */
	XY_PLOT,
	/** Represents the pie chart display type. */
	PIE_CHART,
	/** Represents the plain text display type. */
	PLAIN_TEXT,
	/** Represents the html text display type. */
	HTML_TEXT,
	/** Represents the image display type. */
	IMAGE,
	/** Represents the meter gauge display type. */
	METER_GAUGE,
	/** Represents the tag cloud display type. */
	TAG_CLOUD,
	/** Represents an unknown display type. This field is necessary in order to avoid null values and resulting exceptions. */
	UNKNOWN
}
