/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/
package kieker.webgui.domain;

import java.util.Collections;
import java.util.List;

import kieker.webgui.domain.pluginDecorators.FilterDecorator;
import kieker.webgui.domain.pluginDecorators.ReaderDecorator;
import kieker.webgui.domain.pluginDecorators.RepositoryDecorator;
import kieker.webgui.domain.pluginDecorators.VisualizationDecorator;

/**
 * This is a container for multiple {@link ReaderDecorator}, {@link FilterDecorator} or {@link RepositoryDecorator} instances. For each of the component type
 * (reader, filter, repository) there is exactly one list available. This class will mostly be used to deliver a set of available components for a project. A bean
 * can use the components as a prototype to copy new model instances.
 * 
 * @author Nils Christian Ehmke
 */
public final class ComponentListContainer {

	/** This constant represents an immutable and empty container. */
	public static final ComponentListContainer EMPTY_CONTAINER = new ComponentListContainer(Collections.<ReaderDecorator>emptyList(),
			Collections.<FilterDecorator>emptyList(), Collections.<RepositoryDecorator>emptyList(), Collections.<VisualizationDecorator>emptyList());

	private final List<VisualizationDecorator> visualizations;
	private final List<ReaderDecorator> readers;
	private final List<FilterDecorator> filters;
	private final List<RepositoryDecorator> repositories;

	public ComponentListContainer(final List<ReaderDecorator> readers, final List<FilterDecorator> filters, final List<RepositoryDecorator> repositories,
			final List<VisualizationDecorator> visualizations) {
		this.readers = readers;
		this.filters = filters;
		this.visualizations = visualizations;
		this.repositories = repositories;
	}

	public List<VisualizationDecorator> getVisualizations() {
		return this.visualizations;
	}

	public List<ReaderDecorator> getReaders() {
		return this.readers;
	}

	public List<FilterDecorator> getFilters() {
		return this.filters;
	}

	public List<RepositoryDecorator> getRepositories() {
		return this.repositories;
	}

}
