/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.common.exception;

/**
 * This exception can be thrown if a project could not be saved, because a newer version was available on the file system. In other words: It can indicate, that a
 * project has been modified in the meanwhile.
 * 
 * @author Nils Christian Ehmke
 */
public final class NewerProjectException extends AbstractKiekerWebGUIException {

	private static final long serialVersionUID = 1L;

	/**
	 * Creates a new instance of this exception without detail message. The cause is not initialized, but can later be initialized using
	 * {@link Throwable#initCause(java.lang.Throwable)}.
	 */
	public NewerProjectException() {
		super();
	}

	/**
	 * Creates a new instance of this class using the given detail message. The cause is not initialized, but can later be initialized using
	 * {@link Throwable#initCause(java.lang.Throwable)}.
	 * 
	 * @param msg
	 *            The detail message of the exception.
	 */
	public NewerProjectException(final String msg) {
		super(msg);
	}

	/**
	 * Creates a new instance of this class using the given detail message and cause.
	 * 
	 * @param msg
	 *            The detail message of the exception.
	 * @param cause
	 *            The cause for the exception.
	 */
	public NewerProjectException(final String msg, final Throwable cause) {
		super(msg, cause);
	}

}
