/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.common.exception;

import kieker.analysis.AnalysisController.STATE;

/**
 * This exception can be thrown if the analysis is in an invalid state for the ordered operation.
 * 
 * @author Nils Christian Ehmke
 */
public final class InvalidAnalysisStateException extends AbstractKiekerWebGUIException {

	private static final long serialVersionUID = 1L;

	private final STATE currentAnalysisState;
 
	/**
	 * Creates a new instance of this exception without detail message or current analysis state. The cause is not initialized, but can later be initialized using
	 * {@link Throwable#initCause(java.lang.Throwable)}.
	 */
	public InvalidAnalysisStateException() {
		super();
		this.currentAnalysisState = null;
	}

	/**
	 * Creates a new instance of this class using the given detail message, but without current analysis state. The cause is not initialized, but can later be
	 * initialized using {@link Throwable#initCause(java.lang.Throwable)}.
	 * 
	 * @param msg
	 *            The detail message of the exception.
	 */
	public InvalidAnalysisStateException(final String msg) {
		super(msg);
		this.currentAnalysisState = null;
	}

	/**
	 * Creates a new instance of this class using the given detail message and cause, but without current analysis state.
	 * 
	 * @param msg
	 *            The detail message of the exception.
	 * @param cause
	 *            The cause for the exception.
	 */
	public InvalidAnalysisStateException(final String msg, final Throwable cause) {
		super(msg, cause);
		this.currentAnalysisState = null;
	}

	/**
	 * Creates a new instance of this class using the given detail message, cause, and current analysis state.
	 * 
	 * @param msg
	 *            The detail message of the exception.
	 * @param cause
	 *            The cause for the exception.
	 * @param currentAnalysisState
	 *            The current analysis state.
	 */
	public InvalidAnalysisStateException(final String msg, final Throwable cause, final STATE currentAnalysisState) {
		super(msg, cause);
		this.currentAnalysisState = currentAnalysisState;
	}

	public STATE getState() {
		return this.currentAnalysisState;
	}

}
