/***************************************************************************
 * Copyright 2014 Kieker Project (http://kieker-monitoring.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************************/

package kieker.webgui.common;

/**
 * This class encapsulates a single log entry, including a potential detailed message. Instances of this class are useful for showing exception messages from the
 * analyses in the WebGUI.
 * 
 * @author Nils Christian Ehmke
 */
public final class LogEntry {

	private final String logMessage;
	private final String detailMessage;

	/**
	 * Creates a new log entry without detail message.
	 * 
	 * @param logMessage
	 *            The log message.
	 */
	public LogEntry(final String logMessage) {
		this.logMessage = logMessage;
		this.detailMessage = null;
	}

	/**
	 * Creates a new log entry with detail message.
	 * 
	 * @param logMessage
	 *            The log message.
	 * @param detailMessage
	 *            The detail message.
	 */
	public LogEntry(final String logMessage, final String detailMessage) {
		this.logMessage = logMessage;
		this.detailMessage = detailMessage;
	}

	public String getLogMessage() {
		return this.logMessage;
	}

	public String getDetailMessage() {
		return this.detailMessage;
	}

}
