/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import de.cau.cs.kieler.core.math.BezierSpline;
import de.cau.cs.kieler.core.math.CubicSplineInterpolator;
import de.cau.cs.kieler.core.math.ISplineInterpolator;
import de.cau.cs.kieler.core.math.KVector;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplineGenerator {
    private ISplineInterpolator interp = new CubicSplineInterpolator();
    private static final double INCREASE_FACTOR = 0.5;
    private static final double DECREASE_FACTOR = 0.5;
    private static final double STRAIGHTENING_FACTOR = 0.75;
    private static final double SMOOTHNESS_FACTOR = 0.3;
    private static final double MAX_DISTANCE = 0.75;

    public BezierSpline generateSpline(LinkedList<KVector> pArray, KVector vectorQ, KVector vectorS) {
        BezierSpline spline = vectorQ == null || vectorS == null ? this.interp.interpolatePoints(pArray) : this.interp.interpolatePoints(pArray, vectorQ, vectorS, true);
        if (pArray.size() > 2) {
            this.removeFunnyCycles(spline);
        }
        return spline;
    }

    private void removeFunnyCycles(BezierSpline spline) {
        ListIterator listIt = spline.getCurves().listIterator();
        while (listIt.hasNext()) {
            KVector v1;
            BezierSpline.BezierCurve tempCurve;
            KVector v;
            BezierSpline.BezierCurve curve = (BezierSpline.BezierCurve)listIt.next();
            double dist = KVector.distance(curve.start, curve.end);
            double distFst = KVector.distance(curve.start, curve.fstControlPnt);
            double distSnd = KVector.distance(curve.end, curve.sndControlPnt);
            if (distFst > dist * 0.75) {
                v = KVector.sub(curve.fstControlPnt, curve.start);
                v.scaleToLength(dist * 0.3);
                curve.fstControlPnt = KVector.add(curve.start, v);
                if (listIt.hasPrevious()) {
                    listIt.previous();
                    if (listIt.hasPrevious()) {
                        tempCurve = (BezierSpline.BezierCurve)listIt.previous();
                        v1 = KVector.sub(tempCurve.sndControlPnt, tempCurve.end);
                        v1.scaleToLength(dist * 0.3);
                        tempCurve.sndControlPnt = KVector.add(tempCurve.end, v1);
                        listIt.next();
                    }
                    listIt.next();
                }
            }
            if (!(distSnd > dist * 0.75)) continue;
            v = KVector.sub(curve.sndControlPnt, curve.end);
            v.scaleToLength(dist * 0.3);
            curve.sndControlPnt = KVector.add(curve.end, v);
            if (!listIt.hasNext()) continue;
            tempCurve = (BezierSpline.BezierCurve)listIt.next();
            v1 = KVector.sub(tempCurve.fstControlPnt, tempCurve.start);
            v1.scaleToLength(dist * 0.3);
            tempCurve.fstControlPnt = KVector.add(tempCurve.start, v1);
            listIt.previous();
        }
    }

    public BezierSpline generateSpline(LinkedList<KVector> pArray) {
        return this.generateSpline(pArray, null, null);
    }

    public BezierSpline generateShortSpline(KVector q, KVector s) {
        double widthdiff = Math.abs(q.x - s.x);
        KVector startTan = new KVector(widthdiff, 0.0);
        KVector endTan = new KVector(widthdiff, 0.0);
        BezierSpline spline = this.interp.interpolatePoints(new KVector[]{q, s}, startTan, endTan, false);
        return spline;
    }

    public boolean refineSpline(LinkedList<KVector> pArray, BezierSpline ospline, Curvature mode) {
        for (BezierSpline.BezierCurve curve : ospline.getCurves()) {
            KVector fstdir = KVector.sub(curve.fstControlPnt, curve.start).normalize();
            KVector snddir = KVector.sub(curve.sndControlPnt, curve.end).normalize();
            double dist = KVector.distance(curve.start, curve.fstControlPnt);
            double dist2 = KVector.distance(curve.end, curve.sndControlPnt);
            switch (mode) {
                case decrease: {
                    curve.fstControlPnt.sub(fstdir.scale(0.5 * dist));
                    curve.sndControlPnt.sub(snddir.scale(0.5 * dist2));
                    break;
                }
                case increase: {
                    curve.fstControlPnt.add(fstdir.scale(0.5 * dist));
                    curve.sndControlPnt.add(snddir.scale(0.5 * dist2));
                }
            }
            this.removeFunnyCycles(ospline);
        }
        return true;
    }

    public boolean straightenSpline(BezierSpline spline) {
        if (spline.getCurves().size() != 1) {
            return false;
        }
        BezierSpline.BezierCurve curve = spline.getCurves().getFirst();
        KVector fstdir = KVector.sub(curve.fstControlPnt, curve.start).scale(0.75);
        KVector snddir = KVector.sub(curve.sndControlPnt, curve.end).scale(0.75);
        curve.fstControlPnt.sub(fstdir);
        curve.sndControlPnt.sub(snddir);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Curvature {
        increase,
        decrease;

    }
}

