/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.BezierSpline;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingStrategy;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.p5edges.LongEdge;
import de.cau.cs.kieler.klay.layered.p5edges.SimpleLabelPlacer;
import de.cau.cs.kieler.klay.layered.p5edges.SplineGenerator;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;

public class SplineEdgeRouter
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final int HIGH_LIMIT = 7;
    private static final int MID_LIMIT = 5;
    private static final int SMALL_OFFSET = 2;
    private static final int BIG_OFFSET = 3;
    private static final int VERTICAL_CHANGE = 4;
    private static final int MINIMAL_POINTS_HANDLES = 4;
    private static final int MAX_EDGES = 3;
    private SplineGenerator splineGen = new SplineGenerator();
    private SimpleLabelPlacer labelPlacer = new SimpleLabelPlacer();

    public IntermediateProcessingStrategy getIntermediateProcessingStrategy(LayeredGraph graph) {
        return null;
    }

    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Simple spline routing", 1.0f);
        double defspacing = layeredGraph.getProperty(Properties.OBJ_SPACING).floatValue();
        LinkedList<LEdge> longEdges = new LinkedList<LEdge>();
        LinkedList<LongEdge> realLongEdges = new LinkedList<LongEdge>();
        LinkedList<LEdge> shortEdges = new LinkedList<LEdge>();
        double xpos = 0.0;
        double spacing = 0.0;
        LinkedList<LLabel> consideredLabelsInLayerSize = new LinkedList<LLabel>();
        for (Layer layer : layeredGraph) {
            layer.placeNodes(xpos);
            int edgeCount = 0;
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    edgeCount += port.getOutgoingEdges().size();
                }
                if (node.getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE) continue;
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        if (edge.getTarget().getNode().getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE) {
                            longEdges.add(edge);
                            realLongEdges.add(new LongEdge(edge));
                            continue;
                        }
                        shortEdges.add(edge);
                    }
                }
            }
            spacing = edgeCount <= 3 ? defspacing : defspacing * Math.sqrt(edgeCount);
            xpos += layer.getSize().x + spacing;
            LLabel longestLabelHere = this.labelPlacer.longestLabel(layer);
            if (consideredLabelsInLayerSize.contains(longestLabelHere)) continue;
            xpos += longestLabelHere.getSize().x;
            consideredLabelsInLayerSize.add(longestLabelHere);
        }
        layeredGraph.getSize().x = xpos - spacing;
        int minimalAngle = layeredGraph.getProperty(Properties.MIN_EDGE_ANGLE);
        if (minimalAngle != 0) {
            block5: for (LEdge edge : shortEdges) {
                LPort start = edge.getSource();
                LNode startNode = start.getNode();
                LPort end = edge.getTarget();
                LNode endNode = end.getNode();
                KVector endVec = new KVector(endNode.getPosition().x + end.getPosition().x, endNode.getPosition().y + end.getPosition().y);
                KVector startVec = new KVector(startNode.getPosition().x + start.getPosition().x, startNode.getPosition().y + start.getPosition().y);
                KVector startToEnd = KVector.sub(endVec, startVec);
                double degrees = startToEnd.toDegrees();
                if (!(degrees < (double)minimalAngle) && !(degrees > 180.0 - (double)minimalAngle)) continue;
                BezierSpline spline = this.splineGen.generateShortSpline(startVec, endVec);
                KVector[] kVectorArray = spline.getInnerPoints();
                int n = kVectorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    KVector v = kVectorArray[n2];
                    if (this.getMonitor().isCanceled()) continue block5;
                    edge.getBendPoints().add(v);
                    ++n2;
                }
            }
        }
        block7: for (LongEdge longEdge : realLongEdges) {
            longEdge.initialize();
            KVector startAngle = longEdge.getStartTangent();
            KVector endAngle = longEdge.getEndTangent().negate();
            BezierSpline spline = this.splineGen.generateSpline(longEdge.getPoints(), startAngle, endAngle);
            spline = this.optimizeSpline(spline);
            if (spline == null) continue;
            KVector[] kVectorArray = spline.getInnerPoints();
            int n = kVectorArray.length;
            int n3 = 0;
            while (n3 < n) {
                KVector v = kVectorArray[n3];
                if (this.getMonitor().isCanceled()) continue block7;
                longEdge.getEdge().getBendPoints().add(v);
                ++n3;
            }
        }
        this.labelPlacer.placeLabels(layeredGraph);
        this.getMonitor().done();
    }

    private BezierSpline optimizeSpline(BezierSpline spline) {
        if (spline.getBasePoints().length >= 4 && this.isLongStraightSpline(spline)) {
            int offset;
            KVector[] basePoints = spline.getBasePoints();
            int n = basePoints.length - 1;
            int n2 = offset = n >= 7 ? 3 : 2;
            if (n < 5) {
                offset = 1;
            }
            KVector start = spline.getStartPoint();
            KVector end = spline.getEndPoint();
            LinkedList<KVector> newPoints = new LinkedList<KVector>();
            newPoints.add(start);
            if (n >= 5) {
                KVector intermediateLeft = basePoints[1].clone();
                intermediateLeft.y += (start.y - intermediateLeft.y) / 4.0;
                newPoints.add(intermediateLeft);
            }
            KVector bendLeft = null;
            if (n >= 5) {
                bendLeft = basePoints[offset].clone();
                newPoints.add(bendLeft);
            }
            KVector bendRight = basePoints[n - offset].clone();
            newPoints.add(bendRight);
            if (n >= 5) {
                KVector intermediateRight = basePoints[n - 1].clone();
                intermediateRight.y += (end.y - intermediateRight.y) / 4.0;
                newPoints.add(intermediateRight);
            }
            newPoints.add(end);
            KVector test = null;
            if (bendLeft == null) {
                test = bendRight.clone();
            }
            KVector startTangent = KVector.sub(bendLeft == null ? test : bendLeft, start).normalize();
            KVector endTangent = KVector.sub(bendRight, end).normalize().negate();
            return this.splineGen.generateSpline(newPoints, startTangent, endTangent);
        }
        return spline;
    }

    private boolean isLongStraightSpline(BezierSpline spline) {
        KVector start = spline.getStartPoint();
        KVector end = spline.getEndPoint();
        Integer y = null;
        KVector[] kVectorArray = spline.getBasePoints();
        int n = kVectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            KVector pt = kVectorArray[n2];
            if (pt != start && pt != end) {
                if (y == null) {
                    y = (int)pt.y;
                } else if ((int)pt.y != y) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }
}

