/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.p5edges.LongEdge;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;

public class SimpleLabelPlacer {
    public void placeLabels(LayeredGraph thelayeredGraph) {
        for (Layer layer : thelayeredGraph) {
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getConnectedEdges()) {
                        for (LLabel label : edge.getLabels()) {
                            LongEdge longEdge = null;
                            if (edge.getTarget().getNode().getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE) {
                                longEdge = new LongEdge(edge);
                                longEdge.initialize();
                            }
                            KVector source = new KVector(edge.getSource().getPosition().x, edge.getSource().getPosition().y);
                            KVector target = longEdge == null ? new KVector(edge.getTarget().getPosition().x, edge.getTarget().getPosition().y) : new KVector(longEdge.getTarget().getPosition().x, longEdge.getTarget().getPosition().y);
                            source = source.add(edge.getSource().getNode().getPosition());
                            target = longEdge == null ? target.add(edge.getTarget().getNode().getPosition()) : target.add(longEdge.getTarget().getNode().getPosition());
                            label.getPosition().x = Math.abs(source.x - target.x) / 2.0;
                            if (longEdge == null) {
                                label.getPosition().y = (target.y - source.y) / 2.0;
                            } else {
                                KVector portPosition = new KVector(edge.getSource().getPosition().x, edge.getSource().getPosition().y);
                                portPosition.add(edge.getSource().getNode().getPosition());
                                double minDistanceDifference = Double.POSITIVE_INFINITY;
                                KVector middlePoint = null;
                                for (KVector bPoint : longEdge.getEdge().getBendPoints()) {
                                    KVector vectorBPoint = new KVector(bPoint.x, bPoint.y);
                                    KVector vectorSource = new KVector(source.x, source.y);
                                    KVector vectorTarget = new KVector(target.x, target.y);
                                    double bPointDifference = Math.abs(vectorBPoint.distance(vectorSource) - vectorBPoint.distance(vectorTarget));
                                    if (!(bPointDifference < minDistanceDifference)) continue;
                                    minDistanceDifference = bPointDifference;
                                    middlePoint = bPoint;
                                }
                                label.getPosition().x = middlePoint.x - portPosition.x;
                                label.getPosition().y = middlePoint.y - portPosition.y;
                            }
                            label.getPosition().x -= label.getSize().x / 2.0;
                        }
                    }
                }
            }
        }
    }

    public LLabel longestLabel(Layer thelayer) {
        LLabel longest = new LLabel("");
        for (LNode node : thelayer) {
            for (LEdge edge : node.getOutgoingEdges()) {
                for (LLabel label : edge.getLabels()) {
                    if (!(label.getSize().x > longest.getSize().x)) continue;
                    longest = label;
                }
            }
        }
        return longest;
    }
}

