/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingStrategy;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;

public class PolylineEdgeRouter
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final int MAX_EDGES = 3;

    public IntermediateProcessingStrategy getIntermediateProcessingStrategy(LayeredGraph graph) {
        return null;
    }

    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Polyline edge routing", 1.0f);
        float defspacing = layeredGraph.getProperty(Properties.OBJ_SPACING).floatValue();
        double xpos = 0.0;
        double spacing = 0.0;
        for (Layer layer : layeredGraph) {
            layer.placeNodes(xpos);
            int edgeCount = 0;
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    edgeCount += port.getOutgoingEdges().size();
                }
                if (node.getProperty(Properties.NODE_TYPE) != NodeType.LONG_EDGE) continue;
                LEdge edge = (LEdge)node.getProperty(Properties.ORIGIN);
                if (this.isEndnode(node, true)) {
                    edge.getBendPoints().add(new KVector(xpos, node.getPosition().y));
                }
                if (!this.isEndnode(node, false)) continue;
                edge.getBendPoints().add(new KVector(xpos + layer.getSize().x, node.getPosition().y));
            }
            spacing = edgeCount <= 3 ? (double)defspacing : (double)defspacing * Math.sqrt(edgeCount);
            xpos += layer.getSize().x + spacing;
        }
        layeredGraph.getSize().x = xpos - spacing;
        this.getMonitor().done();
    }

    private boolean isEndnode(LNode node, boolean first) {
        double bendPos = node.getPosition().y;
        for (LPort port : node.getPorts()) {
            Iterable<LPort> connectedPorts = first ? port.getPredecessorPorts() : port.getSuccessorPorts();
            for (LPort connectedPort : connectedPorts) {
                LNode otherNode = connectedPort.getNode();
                double otherPos = otherNode.getPosition().y + connectedPort.getPosition().y;
                if (!(Math.abs(otherPos - bendPos) > 1.0)) continue;
                return true;
            }
        }
        return false;
    }
}

