/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingStrategy;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateLayoutProcessor;
import de.cau.cs.kieler.klay.layered.p5edges.OrthogonalRoutingGenerator;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class OrthogonalEdgeRouter
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final IntermediateProcessingStrategy HYPEREDGE_PROCESSING_ADDITIONS = new IntermediateProcessingStrategy(3, IntermediateLayoutProcessor.HYPEREDGE_DUMMY_MERGER);
    private static final IntermediateProcessingStrategy INVERTED_PORT_PROCESSING_ADDITIONS = new IntermediateProcessingStrategy(2, IntermediateLayoutProcessor.INVERTED_PORT_PROCESSOR);
    private static final IntermediateProcessingStrategy NORTH_SOUTH_PORT_PROCESSING_ADDITIONS = new IntermediateProcessingStrategy(null, null, EnumSet.of(IntermediateLayoutProcessor.NORTH_SOUTH_PORT_PREPROCESSOR), null, null, EnumSet.of(IntermediateLayoutProcessor.NORTH_SOUTH_PORT_POSTPROCESSOR));
    private static final IntermediateProcessingStrategy HIERARCHICAL_PORT_PROCESSING_ADDITIONS = new IntermediateProcessingStrategy(null, null, EnumSet.of(IntermediateLayoutProcessor.HIERARCHICAL_PORT_CONSTRAINT_PROCESSOR), null, EnumSet.of(IntermediateLayoutProcessor.HIERARCHICAL_PORT_DUMMY_SIZE_PROCESSOR), EnumSet.of(IntermediateLayoutProcessor.HIERARCHICAL_PORT_ORTHOGONAL_EDGE_ROUTER));
    private static final IntermediateProcessingStrategy SELF_LOOP_PROCESSING_ADDITIONS = new IntermediateProcessingStrategy(2, IntermediateLayoutProcessor.SELF_LOOP_PROCESSOR);
    private static final IntermediateProcessingStrategy HYPERNODE_PROCESSING_ADDITIONS = new IntermediateProcessingStrategy(5, IntermediateLayoutProcessor.HYPERNODE_PROCESSOR);

    public IntermediateProcessingStrategy getIntermediateProcessingStrategy(LayeredGraph graph) {
        Set<GraphProperties> graphProperties = graph.getProperty(Properties.GRAPH_PROPERTIES);
        IntermediateProcessingStrategy strategy = new IntermediateProcessingStrategy();
        if (graphProperties.contains((Object)GraphProperties.HYPEREDGES)) {
            strategy.addAll(HYPEREDGE_PROCESSING_ADDITIONS);
            strategy.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.NON_FREE_PORTS)) {
            strategy.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
            if (graphProperties.contains((Object)GraphProperties.NORTH_SOUTH_PORTS)) {
                strategy.addAll(NORTH_SOUTH_PORT_PROCESSING_ADDITIONS);
            }
        }
        if (graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            strategy.addAll(HIERARCHICAL_PORT_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.SELF_LOOPS)) {
            strategy.addAll(SELF_LOOP_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.HYPERNODES)) {
            strategy.addAll(HYPERNODE_PROCESSING_ADDITIONS);
        }
        return strategy;
    }

    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Orthogonal edge routing", 1.0f);
        double nodeSpacing = layeredGraph.getProperty(Properties.OBJ_SPACING).floatValue();
        double edgeSpacing = nodeSpacing * (double)layeredGraph.getProperty(Properties.EDGE_SPACING_FACTOR).floatValue();
        boolean debug = layeredGraph.getProperty(LayoutOptions.DEBUG_MODE);
        OrthogonalRoutingGenerator routingGenerator = new OrthogonalRoutingGenerator(new OrthogonalRoutingGenerator.WestToEastRoutingStrategy(), edgeSpacing, debug ? "phase5" : null);
        float xpos = 0.0f;
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        Layer leftLayer = null;
        Layer rightLayer = null;
        List<LNode> leftLayerNodes = null;
        List<LNode> rightLayerNodes = null;
        int leftLayerIndex = -1;
        int rightLayerIndex = -1;
        do {
            int slotsCount;
            rightLayer = layerIter.hasNext() ? layerIter.next() : null;
            rightLayerNodes = rightLayer == null ? null : rightLayer.getNodes();
            rightLayerIndex = layerIter.previousIndex();
            if (leftLayer != null) {
                leftLayer.placeNodes(xpos);
                xpos = (float)((double)xpos + (leftLayer.getSize().x + nodeSpacing));
            }
            if ((slotsCount = routingGenerator.routeEdges(layeredGraph, leftLayerNodes, leftLayerIndex, rightLayerNodes, xpos)) > 0) {
                xpos = (float)((double)xpos + ((double)slotsCount * edgeSpacing - edgeSpacing + nodeSpacing));
            }
            leftLayer = rightLayer;
            leftLayerNodes = rightLayerNodes;
            leftLayerIndex = rightLayerIndex;
        } while (rightLayer != null);
        layeredGraph.getSize().x = xpos;
        this.getMonitor().done();
    }
}

