/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongEdge {
    private LEdge edge;
    private KVector startPoint;
    private KVector startTangent;
    private KVector endPoint;
    private KVector endTangent;
    private LPort target;
    private LinkedList<KVector> points = new LinkedList();

    public LongEdge(LEdge newEdge) {
        this.edge = newEdge;
    }

    public void initialize() {
        LPort start = this.edge.getSource();
        LNode startNode = start.getNode();
        LPort end = this.edge.getTarget();
        LNode endNode = end.getNode();
        this.startPoint = new KVector(startNode.getPosition().x + start.getPosition().x, startNode.getPosition().y + start.getPosition().y);
        this.startTangent = new KVector(endNode.getPosition().x + end.getPosition().x - (startNode.getPosition().x + start.getPosition().x), endNode.getPosition().y + end.getPosition().y - (startNode.getPosition().y + start.getPosition().y));
        this.startTangent.normalize();
        LEdge intermediateEdge = this.edge;
        LNode currentTarget = this.edge.getSource().getNode();
        LPort port = this.edge.getSource();
        this.points.add(new KVector(currentTarget.getPosition().x + port.getPosition().x, currentTarget.getPosition().y + port.getPosition().y));
        do {
            Iterator<LPort> iterator;
            if ((iterator = (currentTarget = (port = intermediateEdge.getTarget()).getNode()).getPorts().iterator()).hasNext()) {
                LPort iterPort = iterator.next();
                for (LEdge iterEdge : iterPort.getOutgoingEdges()) {
                    if (iterEdge.getProperty(Properties.ORIGIN) == null) continue;
                    intermediateEdge = iterEdge;
                    break;
                }
            }
            this.points.add(new KVector(currentTarget.getPosition().x + port.getPosition().x, currentTarget.getPosition().y + port.getPosition().y));
        } while (intermediateEdge.getTarget().getNode().getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE);
        start = intermediateEdge.getSource();
        startNode = start.getNode();
        end = intermediateEdge.getTarget();
        endNode = end.getNode();
        this.endPoint = new KVector(endNode.getPosition().x + end.getPosition().x, endNode.getPosition().y + end.getPosition().y);
        this.endTangent = new KVector(startNode.getPosition().x + start.getPosition().x - (endNode.getPosition().x + end.getPosition().x), startNode.getPosition().y + start.getPosition().y - (endNode.getPosition().y + end.getPosition().y));
        this.endTangent.normalize();
        this.target = end;
        currentTarget = end.getNode();
        this.points.add(new KVector(currentTarget.getPosition().x + end.getPosition().x, currentTarget.getPosition().y + end.getPosition().y));
    }

    public LEdge getEdge() {
        return this.edge;
    }

    public KVector getEndTangent() {
        return this.endTangent;
    }

    public KVector getStartTangent() {
        return this.startTangent;
    }

    public LPort getTarget() {
        return this.target;
    }

    public LinkedList<KVector> getPoints() {
        return this.points;
    }

    public KVector getEndPoint() {
        return this.endPoint;
    }

    public KVector getStartPoint() {
        return this.startPoint;
    }

    public String toString() {
        return "Node: " + this.edge + " StartTangent: " + this.startTangent + " EndTangent: " + this.endTangent;
    }
}

