/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.PortType;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p3order.IPortDistributor;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRelativePortDistributor
implements IPortDistributor {
    private float[] portBarycenter;
    private float[] portPos;
    private static final float INCR_ONE = 0.3f;
    private static final float INCR_TWO = 0.5f;
    private static final float INCR_THREE = 0.7f;
    private static final float INCR_FOUR = 0.9f;

    public NodeRelativePortDistributor(float[] portRanks, float[] portBarycenters) {
        this.portPos = portRanks;
        this.portBarycenter = portBarycenters;
    }

    @Override
    public void calculatePortRanks(LNode[] layer) {
        int nodeIx = 0;
        LNode[] lNodeArray = layer;
        int n = layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            int inputPorts = 0;
            int outputPorts = 0;
            for (LPort port : node.getPorts()) {
                if (port.getNetFlow() < 0) {
                    ++outputPorts;
                    continue;
                }
                ++inputPorts;
            }
            if (inputPorts > 0) {
                this.calculatePortRanks(node, nodeIx, PortType.INPUT, inputPorts);
            }
            if (outputPorts > 0) {
                this.calculatePortRanks(node, nodeIx, PortType.OUTPUT, outputPorts);
            }
            ++nodeIx;
            ++n2;
        }
    }

    private void calculatePortRanks(LNode node, int nodeIx, PortType type, int count) {
        if (node.getProperty(LayoutOptions.PORT_CONSTRAINTS).isOrderFixed()) {
            float incr = 1.0f / (float)count;
            if (type == PortType.INPUT) {
                List<LPort> portList = this.getSortedInputPorts(node);
                float pos = (float)(nodeIx + 1) - incr;
                for (LPort port : portList) {
                    this.portPos[port.id] = pos;
                    pos -= incr;
                }
            } else {
                float pos = nodeIx;
                for (LPort port : node.getPorts(type)) {
                    this.portPos[port.id] = pos;
                    pos += incr;
                }
            }
        } else {
            for (LPort port : node.getPorts(type)) {
                this.portPos[port.id] = (float)nodeIx + NodeRelativePortDistributor.getPortIncr(type, port.getSide());
            }
        }
    }

    @Override
    public List<LPort> getSortedInputPorts(LNode node) {
        LinkedList<LPort> northPorts = new LinkedList<LPort>();
        LinkedList<LPort> portList = new LinkedList<LPort>();
        for (LPort port : node.getPorts(PortType.INPUT)) {
            if (port.getSide() == PortSide.NORTH) {
                northPorts.add(port);
                continue;
            }
            portList.add(port);
        }
        portList.addAll(northPorts);
        return portList;
    }

    private static float getPortIncr(PortType type, PortSide side) {
        switch (type) {
            case INPUT: {
                switch (side) {
                    case NORTH: {
                        return 0.3f;
                    }
                    case WEST: {
                        return 0.5f;
                    }
                    case SOUTH: {
                        return 0.7f;
                    }
                    case EAST: {
                        return 0.9f;
                    }
                }
                break;
            }
            case OUTPUT: {
                switch (side) {
                    case NORTH: {
                        return 0.3f;
                    }
                    case EAST: {
                        return 0.5f;
                    }
                    case SOUTH: {
                        return 0.7f;
                    }
                    case WEST: {
                        return 0.9f;
                    }
                }
            }
        }
        return 0.0f;
    }

    @Override
    public void distributePorts(LNode[][] layeredGraph) {
        int l = 0;
        while (l < layeredGraph.length) {
            if (l + 1 < layeredGraph.length) {
                this.calculatePortRanks(layeredGraph[l + 1]);
            }
            LNode[] layer = layeredGraph[l];
            int i = 0;
            while (i < layer.length) {
                LNode node = layer[i];
                if (!node.getProperty(LayoutOptions.PORT_CONSTRAINTS).isOrderFixed()) {
                    this.distributePorts(node);
                    node.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_ORDER);
                    int outputPortCount = 0;
                    for (LPort port : node.getPorts()) {
                        if (port.getNetFlow() >= 0) continue;
                        ++outputPortCount;
                    }
                    if (outputPortCount > 0) {
                        this.calculatePortRanks(node, i, PortType.OUTPUT, outputPortCount);
                    }
                }
                ++i;
            }
            ++l;
        }
    }

    private void distributePorts(LNode node) {
        for (LPort port : node.getPorts()) {
            float sum = 0.0f;
            for (LPort connectedPort : port.getConnectedPorts()) {
                sum += this.portPos[connectedPort.id];
            }
            this.portBarycenter[port.id] = port.getDegree() == 0 ? -1.0f : sum / (float)port.getDegree();
        }
        NodeRelativePortDistributor.sortPorts(node, this.portBarycenter);
    }

    private static void sortPorts(LNode node, final float[] position) {
        Collections.sort(node.getPorts(), new Comparator<LPort>(){

            @Override
            public int compare(LPort port1, LPort port2) {
                PortType type2;
                PortSide side1 = port1.getSide();
                PortType type1 = port1.getNetFlow() >= 0 ? PortType.INPUT : PortType.OUTPUT;
                PortSide side2 = port2.getSide();
                PortType portType = type2 = port2.getNetFlow() >= 0 ? PortType.INPUT : PortType.OUTPUT;
                if (side1 != side2) {
                    return side1.ordinal() - side2.ordinal();
                }
                if (type1 != type2) {
                    if (side1 == PortSide.NORTH) {
                        return type1.ordinal() - type2.ordinal();
                    }
                    return type2.ordinal() - type1.ordinal();
                }
                float pos1 = position[port1.id];
                float pos2 = position[port2.id];
                if (type1 == PortType.INPUT) {
                    return Float.compare(pos2, pos1);
                }
                return Float.compare(pos1, pos2);
            }
        });
    }
}

