/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import de.cau.cs.kieler.klay.layered.graph.LNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeGroup
implements Comparable<NodeGroup> {
    private Random random;
    private List<LNode> nodes = new LinkedList<LNode>();
    private List<NodeGroup> outgoingConstraints = new LinkedList<NodeGroup>();
    private int incomingConstraintsCount = 0;
    private float summedWeight = 0.0f;
    private int degree = 0;
    private float barycenter = -1.0f;

    public NodeGroup(LNode node, Random graphRandom) {
        this.nodes.add(node);
        this.random = graphRandom;
    }

    public NodeGroup(NodeGroup nodeGroup1, NodeGroup nodeGroup2, Random graphRandom) {
        this.nodes.addAll(nodeGroup1.nodes);
        this.nodes.addAll(nodeGroup2.nodes);
        this.random = graphRandom;
        this.outgoingConstraints.addAll(nodeGroup1.outgoingConstraints);
        this.outgoingConstraints.remove(nodeGroup2);
        for (NodeGroup candidate : nodeGroup2.outgoingConstraints) {
            if (candidate == nodeGroup1) continue;
            if (this.outgoingConstraints.contains(candidate)) {
                candidate.setIncomingConstraintsCount(candidate.getIncomingConstraintsCount() - 1);
                continue;
            }
            this.outgoingConstraints.add(candidate);
        }
        this.summedWeight = nodeGroup1.summedWeight + nodeGroup2.summedWeight;
        this.degree = nodeGroup1.degree + nodeGroup2.degree;
        if (this.degree > 0) {
            this.barycenter = this.summedWeight / (float)this.degree;
        }
    }

    public int getIncomingConstraintsCount() {
        return this.incomingConstraintsCount;
    }

    public void setIncomingConstraintsCount(int value) {
        this.incomingConstraintsCount = value;
    }

    public List<NodeGroup> getOutgoingConstraints() {
        return this.outgoingConstraints;
    }

    public List<LNode> getNodes() {
        return this.nodes;
    }

    public float getBarycenter() {
        return this.barycenter;
    }

    public void setBarycenter(float value) {
        this.barycenter = value;
    }

    public float getSummedWeight() {
        return this.summedWeight;
    }

    public void setSummedWeight(float value) {
        this.summedWeight = value;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int value) {
        this.degree = value;
    }

    @Override
    public int compareTo(NodeGroup other) {
        if (this.nodes.isEmpty() || other.nodes.isEmpty()) {
            return other.nodes.size() - this.nodes.size();
        }
        if (this.barycenter == other.barycenter) {
            return this.random.nextBoolean() ? 1 : -1;
        }
        return Float.compare(this.barycenter, other.barycenter);
    }
}

