/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.properties.MapPropertyHolder;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.PortType;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.p3order.AbstractCrossingMinimizer;
import de.cau.cs.kieler.klay.layered.p3order.CompoundGraphLayerCrossingMinimizer;
import de.cau.cs.kieler.klay.layered.p3order.IPortDistributor;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.p3order.NodeRelativePortDistributor;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerSweepCrossingMinimizer
extends AbstractCrossingMinimizer {
    private Multimap<LNode, LNode> layoutUnits;
    private Map<LNode, NodeGroup>[] singleNodeNodeGroups;
    private Random random;
    private CompoundGraphLayerCrossingMinimizer compoundMinimizer;
    private IPortDistributor portDistributor;

    @Override
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Layer sweep crossing minimization", 1.0f);
        this.random = layeredGraph.getProperty(Properties.RANDOM);
        int layerCount = layeredGraph.getLayers().size();
        if (layerCount < 2) {
            this.getMonitor().done();
            return;
        }
        LNode[][] bestSweep = new LNode[layerCount][];
        LNode[][] curSweep = new LNode[layerCount][];
        LNode[][] prevSweep = new LNode[layerCount][];
        int bestSweepCrossings = Integer.MAX_VALUE;
        int curSweepCrossings = Integer.MAX_VALUE;
        int prevSweepCrossings = Integer.MAX_VALUE;
        this.layoutUnits = HashMultimap.create();
        this.singleNodeNodeGroups = new HashMap[layerCount];
        int nodeCount = 0;
        int portCount = 0;
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerIndex = layerIter.previousIndex();
            int layerNodeCount = layer.getNodes().size();
            bestSweep[layerIndex] = new LNode[layerNodeCount];
            prevSweep[layerIndex] = new LNode[layerNodeCount];
            curSweep[layerIndex] = new LNode[layerNodeCount];
            this.singleNodeNodeGroups[layerIndex] = new HashMap<LNode, NodeGroup>();
            ListIterator<LNode> nodeIter = layer.getNodes().listIterator();
            while (nodeIter.hasNext()) {
                LNode node;
                curSweep[layerIndex][nodeIter.previousIndex()] = node = nodeIter.next();
                node.id = nodeCount++;
                this.layoutUnits.put((Object)node.getProperty(Properties.IN_LAYER_LAYOUT_UNIT), (Object)node);
                this.singleNodeNodeGroups[layerIndex].put(node, new NodeGroup(node, this.random));
                for (LPort port : node.getPorts()) {
                    port.id = portCount++;
                }
            }
        }
        this.portBarycenter = new float[portCount];
        this.portPos = new float[portCount];
        int runCount = layeredGraph.getProperty(Properties.THOROUGHNESS);
        KNode kgraph = (KNode)layeredGraph.getProperty(Properties.ORIGIN);
        KShapeLayout sourceShapeLayout = kgraph.getData(KShapeLayout.class);
        boolean isCompound = sourceShapeLayout.getProperty(LayoutOptions.LAYOUT_HIERARCHY);
        this.portDistributor = new NodeRelativePortDistributor(this.portPos, this.portBarycenter);
        this.compoundMinimizer = new CompoundGraphLayerCrossingMinimizer(this.portDistributor, this.random, isCompound, this.portPos, this.singleNodeNodeGroups, this.layoutUnits);
        int run = 0;
        while (run < runCount) {
            boolean forward = this.random.nextBoolean();
            int fixedLayerIndex = forward ? 0 : layerCount - 1;
            LNode[] fixedLayer = curSweep[fixedLayerIndex];
            int totalEdges = 0;
            this.compoundMinimizer.compoundMinimizeCrossings(fixedLayer, fixedLayerIndex, forward, false, true, layeredGraph);
            prevSweepCrossings = Integer.MAX_VALUE;
            curSweepCrossings = Integer.MAX_VALUE;
            boolean firstSweep = true;
            do {
                LNode[] freeLayer;
                int layerIndex;
                LayerSweepCrossingMinimizer.copySweep(curSweep, prevSweep);
                prevSweepCrossings = curSweepCrossings;
                curSweepCrossings = 0;
                if (forward) {
                    layerIndex = 1;
                    while (layerIndex < layerCount) {
                        freeLayer = curSweep[layerIndex];
                        totalEdges = this.compoundMinimizer.compoundMinimizeCrossings(freeLayer, layerIndex, true, !firstSweep, false, layeredGraph);
                        curSweepCrossings += this.countCrossings(fixedLayer, freeLayer, totalEdges) + this.countCrossings(freeLayer);
                        fixedLayer = freeLayer;
                        ++layerIndex;
                    }
                } else {
                    layerIndex = layerCount - 2;
                    while (layerIndex >= 0) {
                        freeLayer = curSweep[layerIndex];
                        totalEdges = this.compoundMinimizer.compoundMinimizeCrossings(freeLayer, layerIndex, false, !firstSweep, false, layeredGraph);
                        curSweepCrossings += this.countCrossings(freeLayer, fixedLayer, totalEdges) + this.countCrossings(freeLayer);
                        fixedLayer = freeLayer;
                        --layerIndex;
                    }
                }
                firstSweep = false;
                boolean bl = forward = !forward;
            } while (curSweepCrossings < prevSweepCrossings);
            if (curSweepCrossings < bestSweepCrossings || prevSweepCrossings < bestSweepCrossings) {
                if (curSweepCrossings < prevSweepCrossings) {
                    LayerSweepCrossingMinimizer.copySweep(curSweep, bestSweep);
                    bestSweepCrossings = curSweepCrossings;
                } else {
                    LayerSweepCrossingMinimizer.copySweep(prevSweep, bestSweep);
                    bestSweepCrossings = prevSweepCrossings;
                }
            }
            ++run;
        }
        this.portDistributor.distributePorts(bestSweep);
        layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            LNode[] nodes = bestSweep[layerIter.previousIndex()];
            ListIterator<LNode> nodeIter = layer.getNodes().listIterator();
            while (nodeIter.hasNext()) {
                nodeIter.next();
                nodeIter.set(nodes[nodeIter.previousIndex()]);
            }
        }
        this.dispose();
        this.getMonitor().done();
    }

    private void dispose() {
        this.portBarycenter = null;
        this.portPos = null;
        this.layoutUnits = null;
        this.singleNodeNodeGroups = null;
    }

    private int countCrossings(LNode[] leftLayer, LNode[] rightLayer, int edgeCount) {
        Object portIter;
        HashMap<LPort, Integer> targetMap = new HashMap<LPort, Integer>();
        int targetCount = 0;
        LNode[] lNodeArray = rightLayer;
        int n = rightLayer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            if (node.getProperty(LayoutOptions.PORT_CONSTRAINTS).isOrderFixed()) {
                List<LPort> inputPorts = this.portDistributor.getSortedInputPorts(node);
                portIter = inputPorts.listIterator(inputPorts.size());
                while (portIter.hasPrevious()) {
                    targetMap.put((LPort)portIter.previous(), targetCount++);
                }
            } else {
                for (LPort port : node.getPorts(PortType.INPUT)) {
                    targetMap.put(port, targetCount);
                }
                ++targetCount;
            }
            ++n2;
        }
        int[] southSequence = new int[edgeCount];
        int i = 0;
        portIter = leftLayer;
        int port = leftLayer.length;
        int n3 = 0;
        while (n3 < port) {
            Integer pos;
            Object node = portIter[n3];
            if (((MapPropertyHolder)node).getProperty(LayoutOptions.PORT_CONSTRAINTS).isOrderFixed()) {
                for (LPort port2 : ((LNode)node).getPorts(PortType.OUTPUT)) {
                    int start = i;
                    for (LEdge edge : port2.getOutgoingEdges()) {
                        pos = (Integer)targetMap.get(edge.getTarget());
                        if (pos == null) continue;
                        LayerSweepCrossingMinimizer.insert(southSequence, start, i++, pos);
                    }
                }
            } else {
                int start = i;
                for (LPort port3 : ((LNode)node).getPorts(PortType.OUTPUT)) {
                    for (LEdge edge : port3.getOutgoingEdges()) {
                        pos = (Integer)targetMap.get(edge.getTarget());
                        if (pos == null) continue;
                        LayerSweepCrossingMinimizer.insert(southSequence, start, i++, pos);
                    }
                }
            }
            ++n3;
        }
        int firstIndex = 1;
        while (firstIndex < targetCount) {
            firstIndex *= 2;
        }
        int treeSize = 2 * firstIndex - 1;
        --firstIndex;
        int[] tree = new int[treeSize];
        int crossCount = 0;
        int k = 0;
        while (k < edgeCount) {
            int index;
            int n4 = index = southSequence[k] + firstIndex;
            tree[n4] = tree[n4] + 1;
            while (index > 0) {
                if (index % 2 > 0) {
                    crossCount += tree[index + 1];
                }
                int n5 = index = (index - 1) / 2;
                tree[n5] = tree[n5] + 1;
            }
            ++k;
        }
        return crossCount;
    }

    private int countCrossings(LNode[] layer) {
        int crossings = 0;
        HashMap<LNode, Pair<Integer, Integer>> northSouthCrossingHints = new HashMap<LNode, Pair<Integer, Integer>>();
        HashMap<LNode, Integer> dummyIndices = new HashMap<LNode, Integer>();
        HashMap<LPort, Integer> easternPortNumbers = new HashMap<LPort, Integer>();
        HashMap<LPort, Integer> westernPortNumbers = new HashMap<LPort, Integer>();
        this.numberEastWestPorts(layer, easternPortNumbers, westernPortNumbers);
        LNode currentNormalNode = null;
        int northMaxCrossingHint = 0;
        int southMaxCrossingHint = 0;
        boolean northernSide = true;
        boolean layerLayoutUnitsSet = true;
        LNode[] lNodeArray = layer;
        int n = layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            for (LPort port : node.getPorts()) {
                switch (port.getSide()) {
                    case EAST: {
                        crossings += this.countInLayerCrossings(port, easternPortNumbers);
                        break;
                    }
                    case WEST: {
                        crossings += this.countInLayerCrossings(port, westernPortNumbers);
                    }
                }
            }
            NodeType nodeType = node.getProperty(Properties.NODE_TYPE);
            if (layerLayoutUnitsSet && (nodeType == NodeType.NORMAL || nodeType == NodeType.NORTH_SOUTH_PORT)) {
                LNode newNormalNode = node.getProperty(Properties.IN_LAYER_LAYOUT_UNIT);
                if (newNormalNode == null) {
                    layerLayoutUnitsSet = false;
                } else {
                    if (currentNormalNode != newNormalNode) {
                        if (currentNormalNode != null) {
                            northSouthCrossingHints.put(currentNormalNode, new Pair<Integer, Integer>(northMaxCrossingHint, southMaxCrossingHint));
                        }
                        currentNormalNode = newNormalNode;
                        northMaxCrossingHint = 0;
                        southMaxCrossingHint = 0;
                        northernSide = true;
                    }
                    if (node == currentNormalNode) {
                        northernSide = false;
                    }
                    if (northernSide) {
                        dummyIndices.put(node, northMaxCrossingHint += node.getProperty(Properties.CROSSING_HINT).intValue());
                    } else {
                        dummyIndices.put(node, southMaxCrossingHint += node.getProperty(Properties.CROSSING_HINT).intValue());
                    }
                }
            }
            ++n2;
        }
        if (currentNormalNode != null) {
            northSouthCrossingHints.put(currentNormalNode, new Pair<Integer, Integer>(northMaxCrossingHint, southMaxCrossingHint));
        }
        if (layerLayoutUnitsSet) {
            LNode lastDummyNormalNode = null;
            int lastDummyIndex = 0;
            int dummyCount = 0;
            LNode[] lNodeArray2 = layer;
            int n3 = layer.length;
            int n4 = 0;
            while (n4 < n3) {
                LNode node = lNodeArray2[n4];
                NodeType nodeType = node.getProperty(Properties.NODE_TYPE);
                switch (nodeType) {
                    case NORMAL: {
                        lastDummyIndex = (Integer)dummyIndices.get(node);
                        lastDummyNormalNode = node;
                        dummyCount = (Integer)((Pair)northSouthCrossingHints.get(node)).getSecond();
                        break;
                    }
                    case NORTH_SOUTH_PORT: {
                        lastDummyIndex = (Integer)dummyIndices.get(node);
                        LNode newNormalNode = node.getProperty(Properties.IN_LAYER_LAYOUT_UNIT);
                        if (newNormalNode == lastDummyNormalNode) break;
                        dummyCount = (Integer)((Pair)northSouthCrossingHints.get(newNormalNode)).getFirst();
                        lastDummyNormalNode = newNormalNode;
                        break;
                    }
                    default: {
                        crossings += dummyCount - lastDummyIndex;
                    }
                }
                ++n4;
            }
        }
        return crossings;
    }

    private void numberEastWestPorts(LNode[] layer, Map<LPort, Integer> easternMap, Map<LPort, Integer> westernMap) {
        LNode node;
        int currentEasternNumber = 0;
        int currentWesternNumber = 0;
        int nodeIndex = 0;
        while (nodeIndex < layer.length) {
            node = layer[nodeIndex];
            if (node.getProperty(LayoutOptions.PORT_CONSTRAINTS).isOrderFixed()) {
                for (LPort easternPort : node.getPorts(PortSide.EAST)) {
                    if (easternPort.getDegree() <= 0) continue;
                    easternMap.put(easternPort, currentEasternNumber += easternPort.getDegree());
                }
            } else {
                for (LPort easternPort : node.getPorts(PortSide.EAST)) {
                    currentEasternNumber += easternPort.getDegree();
                }
                for (LPort easternPort : node.getPorts(PortSide.EAST)) {
                    if (easternPort.getDegree() <= 0) continue;
                    easternMap.put(easternPort, currentEasternNumber);
                }
            }
            ++nodeIndex;
        }
        nodeIndex = layer.length - 1;
        while (nodeIndex >= 0) {
            node = layer[nodeIndex];
            if (node.getProperty(LayoutOptions.PORT_CONSTRAINTS).isOrderFixed()) {
                for (LPort westernPort : node.getPorts(PortSide.WEST)) {
                    if (westernPort.getDegree() <= 0) continue;
                    westernMap.put(westernPort, currentWesternNumber += westernPort.getDegree());
                }
            } else {
                for (LPort westernPort : node.getPorts(PortSide.WEST)) {
                    currentWesternNumber += westernPort.getDegree();
                }
                for (LPort westernPort : node.getPorts(PortSide.WEST)) {
                    if (westernPort.getDegree() <= 0) continue;
                    westernMap.put(westernPort, currentWesternNumber);
                }
            }
            --nodeIndex;
        }
    }

    private int countInLayerCrossings(LPort port, Map<LPort, Integer> portIndices) {
        int maxCrossings = 0;
        Integer portIndex = portIndices.get(port);
        if (portIndex == null) {
            return 0;
        }
        Integer connectedPortIndex = null;
        for (LEdge edge : port.getConnectedEdges()) {
            connectedPortIndex = edge.getSource() == port ? portIndices.get(edge.getTarget()) : portIndices.get(edge.getSource());
            if (connectedPortIndex == null || portIndex <= connectedPortIndex) continue;
            maxCrossings = Math.max(maxCrossings, portIndex - connectedPortIndex - 1);
        }
        return maxCrossings;
    }

    private static void copySweep(LNode[][] source, LNode[][] dest) {
        int i = 0;
        while (i < dest.length) {
            int j = 0;
            while (j < dest[i].length) {
                dest[i][j] = source[i][j];
                ++j;
            }
            ++i;
        }
    }

    private static void insert(int[] array, int start, int end, int n) {
        int insx = LayerSweepCrossingMinimizer.binarySearch(array, start, end, n);
        if (insx < 0) {
            insx = -insx - 1;
        }
        int j = end - 1;
        while (j >= insx) {
            array[j + 1] = array[j];
            --j;
        }
        if (insx >= array.length) {
            System.out.println("BLA!");
        } else {
            array[insx] = n;
        }
    }

    private static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

