/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.p3order.IConstraintResolver;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForsterConstraintResolver
implements IConstraintResolver {
    @Override
    public void processConstraints(List<NodeGroup> nodeGroups, int layerIndex, Random random, Map<LNode, NodeGroup>[] singleNodeNodeGroups, Multimap<LNode, LNode> layoutUnits) {
        this.buildConstraintsGraph(nodeGroups, singleNodeNodeGroups[layerIndex], layoutUnits);
        Pair<NodeGroup, NodeGroup> violatedConstraint = null;
        while ((violatedConstraint = this.findViolatedConstraint(nodeGroups)) != null) {
            this.handleViolatedConstraint(violatedConstraint, nodeGroups, random);
        }
    }

    private void buildConstraintsGraph(List<NodeGroup> nodeGroups, Map<LNode, NodeGroup> layerNodeGroups, Multimap<LNode, LNode> layoutUnits) {
        for (NodeGroup nodeGroup : nodeGroups) {
            nodeGroup.getOutgoingConstraints().clear();
            nodeGroup.setIncomingConstraintsCount(0);
        }
        LNode lastNonDummyNode = null;
        for (NodeGroup nodeGroup : nodeGroups) {
            LNode vertexNode = nodeGroup.getNodes().get(0);
            LNode successor = vertexNode.getProperty(Properties.IN_LAYER_SUCCESSOR_CONSTRAINT);
            if (successor != null) {
                NodeGroup successorNodeGroup = layerNodeGroups.get(successor);
                nodeGroup.getOutgoingConstraints().add(successorNodeGroup);
                successorNodeGroup.setIncomingConstraintsCount(successorNodeGroup.getIncomingConstraintsCount() + 1);
            }
            if (vertexNode.getProperty(Properties.NODE_TYPE) != NodeType.NORMAL) continue;
            if (lastNonDummyNode != null) {
                for (LNode lastUnitNode : layoutUnits.get((Object)lastNonDummyNode)) {
                    NodeGroup lastUnitNodeGroup = layerNodeGroups.get(lastUnitNode);
                    for (LNode currentUnitNode : layoutUnits.get((Object)vertexNode)) {
                        NodeGroup currentUnitNodeGroup = layerNodeGroups.get(currentUnitNode);
                        lastUnitNodeGroup.getOutgoingConstraints().add(currentUnitNodeGroup);
                        currentUnitNodeGroup.setIncomingConstraintsCount(currentUnitNodeGroup.getIncomingConstraintsCount() + 1);
                    }
                }
            }
            lastNonDummyNode = vertexNode;
        }
    }

    private Pair<NodeGroup, NodeGroup> findViolatedConstraint(List<NodeGroup> nodeGroups) {
        LinkedList<NodeGroup> activeNodeGroups = new LinkedList<NodeGroup>();
        HashMap incoming = new HashMap();
        for (NodeGroup nodeGroup : nodeGroups) {
            if (nodeGroup.getIncomingConstraintsCount() == 0 && nodeGroup.getOutgoingConstraints().isEmpty()) continue;
            incoming.put(nodeGroup, new LinkedList());
            if (nodeGroup.getIncomingConstraintsCount() != 0) continue;
            activeNodeGroups.add(nodeGroup);
        }
        while (!activeNodeGroups.isEmpty()) {
            NodeGroup nodeGroup;
            nodeGroup = (NodeGroup)activeNodeGroups.remove(0);
            for (NodeGroup predecessor : (List)incoming.get(nodeGroup)) {
                if (!(predecessor.getBarycenter() >= nodeGroup.getBarycenter())) continue;
                return new Pair<NodeGroup, NodeGroup>(predecessor, nodeGroup);
            }
            for (NodeGroup successor : nodeGroup.getOutgoingConstraints()) {
                List successorIncomingList = (List)incoming.get(successor);
                successorIncomingList.add(0, nodeGroup);
                if (successor.getIncomingConstraintsCount() != successorIncomingList.size()) continue;
                activeNodeGroups.add(successor);
            }
        }
        return null;
    }

    private void handleViolatedConstraint(Pair<NodeGroup, NodeGroup> violatedConstraint, List<NodeGroup> nodeGroups, Random random) {
        NodeGroup firstNodeGroup = violatedConstraint.getFirst();
        NodeGroup secondNodeGroup = violatedConstraint.getSecond();
        NodeGroup newNodeGroup = new NodeGroup(violatedConstraint.getFirst(), violatedConstraint.getSecond(), random);
        ListIterator<NodeGroup> nodeGroupIterator = nodeGroups.listIterator();
        boolean alreadyInserted = false;
        while (nodeGroupIterator.hasNext()) {
            NodeGroup nodeGroup = nodeGroupIterator.next();
            if (nodeGroup == firstNodeGroup || nodeGroup == secondNodeGroup) {
                nodeGroupIterator.remove();
                continue;
            }
            if (!alreadyInserted && nodeGroup.getBarycenter() > newNodeGroup.getBarycenter()) {
                nodeGroupIterator.previous();
                nodeGroupIterator.add(newNodeGroup);
                alreadyInserted = true;
                continue;
            }
            boolean firstNodeGroupConstraint = nodeGroup.getOutgoingConstraints().remove(firstNodeGroup);
            boolean secondNodeGroupConstraint = nodeGroup.getOutgoingConstraints().remove(secondNodeGroup);
            if (!firstNodeGroupConstraint && !secondNodeGroupConstraint) continue;
            nodeGroup.getOutgoingConstraints().add(newNodeGroup);
            newNodeGroup.setIncomingConstraintsCount(newNodeGroup.getIncomingConstraintsCount() + 1);
        }
        if (!alreadyInserted) {
            nodeGroups.add(newNodeGroup);
        }
    }
}

