/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.p3order.BarycenterHeuristic;
import de.cau.cs.kieler.klay.layered.p3order.ICrossingMinimizationHeuristic;
import de.cau.cs.kieler.klay.layered.p3order.IPortDistributor;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundGraphLayerCrossingMinimizer {
    private IPortDistributor portDistributor;
    private Random random;
    private boolean isCompound;
    private float[] portPos;
    private Map<LNode, NodeGroup>[] singleNodeNodeGroups;
    private Multimap<LNode, LNode> layoutUnits;
    private ICrossingMinimizationHeuristic minimizationHeuristic;

    protected CompoundGraphLayerCrossingMinimizer(IPortDistributor selPortDistributor, Random graphRandom, boolean handleHierarchy, float[] portRanks, Map<LNode, NodeGroup>[] oneNodeNodeGroups, Multimap<LNode, LNode> layoutUnit) {
        this.portDistributor = selPortDistributor;
        this.random = graphRandom;
        this.isCompound = handleHierarchy;
        this.portPos = portRanks;
        this.singleNodeNodeGroups = oneNodeNodeGroups;
        this.layoutUnits = layoutUnit;
    }

    protected int compoundMinimizeCrossings(LNode[] layer, int layerIndex, boolean forward, boolean preOrdered, boolean randomize, LayeredGraph layeredGraph) {
        this.minimizationHeuristic = new BarycenterHeuristic(this.portDistributor, this.random);
        HashMap<KGraphElement, LGraphElement> elemMap = layeredGraph.getProperty(Properties.ELEMENT_MAP);
        LNode graphKey = new LNode();
        graphKey.setProperty(Properties.ORIGIN, layeredGraph);
        int totalEdges = 0;
        if (layer.length == 0) {
            return 0;
        }
        if (!this.isCompound) {
            LinkedList<NodeGroup> layerNodeGroups = new LinkedList<NodeGroup>();
            LNode[] lNodeArray = layer;
            int n = layer.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                layerNodeGroups.add(this.singleNodeNodeGroups[layerIndex].get(node));
                ++n2;
            }
            totalEdges = this.minimizationHeuristic.minimizeCrossings(layerNodeGroups, this.layoutUnits, layerIndex, preOrdered, randomize, forward, this.portPos, this.singleNodeNodeGroups);
            this.applyNodeGroupOrderingToNodeArray(layerNodeGroups, layer);
        } else {
            HashMap<LNode, LinkedList> compoundNodesMap = new HashMap<LNode, LinkedList>();
            LinkedList<LNode> compoundNodesMapKeys = new LinkedList<LNode>();
            int maximalDepth = 0;
            LNode[] lNodeArray = layer;
            int n = layer.length;
            int n3 = 0;
            while (n3 < n) {
                LinkedList relatedList;
                LNode node = lNodeArray[n3];
                LNode key = Util.getRelatedCompoundNode(node, layeredGraph);
                if (key == null) {
                    key = graphKey;
                }
                if (compoundNodesMap.containsKey(key)) {
                    relatedList = (LinkedList)compoundNodesMap.get(key);
                } else {
                    relatedList = new LinkedList();
                    compoundNodesMap.put(key, relatedList);
                    compoundNodesMapKeys.add(key);
                }
                NodeGroup thisNodesGroup = this.singleNodeNodeGroups[layerIndex].get(node);
                relatedList.add(thisNodesGroup);
                int keydepth = key.getProperty(Properties.DEPTH);
                if (keydepth > maximalDepth) {
                    maximalDepth = keydepth;
                }
                ++n3;
            }
            LinkedList compoundNodesPerDepthLevel = new LinkedList();
            int i = 0;
            while (i <= maximalDepth) {
                LinkedList depthList = new LinkedList();
                compoundNodesPerDepthLevel.add(depthList);
                ++i;
            }
            for (LNode compoundNode : compoundNodesMapKeys) {
                ((LinkedList)compoundNodesPerDepthLevel.get(compoundNode.getProperty(Properties.DEPTH))).add(compoundNode);
            }
            while (!compoundNodesPerDepthLevel.isEmpty()) {
                LinkedList actualList = (LinkedList)compoundNodesPerDepthLevel.removeLast();
                for (LNode keyNode : actualList) {
                    LinkedList compoundContent = (LinkedList)compoundNodesMap.get(keyNode);
                    totalEdges += this.minimizationHeuristic.minimizeCrossings(compoundContent, this.layoutUnits, layerIndex, preOrdered, randomize, forward, this.portPos, this.singleNodeNodeGroups);
                    if (keyNode != graphKey) {
                        LinkedList parentContents;
                        LNode parentKey;
                        NodeGroup aggregatedNodeGroup;
                        if (compoundContent.size() == 1) {
                            aggregatedNodeGroup = (NodeGroup)compoundContent.getFirst();
                        } else {
                            aggregatedNodeGroup = new NodeGroup((NodeGroup)compoundContent.removeFirst(), (NodeGroup)compoundContent.removeLast(), this.random);
                            while (!compoundContent.isEmpty()) {
                                aggregatedNodeGroup = new NodeGroup(aggregatedNodeGroup, (NodeGroup)compoundContent.removeFirst(), this.random);
                            }
                        }
                        KNode keyNodeParent = keyNode.getProperty(Properties.K_PARENT);
                        LGraphElement parentRepresentative = elemMap.get(keyNodeParent);
                        if (parentRepresentative instanceof LayeredGraph) {
                            parentKey = graphKey;
                        } else {
                            assert (parentRepresentative instanceof LNode);
                            parentKey = (LNode)parentRepresentative;
                        }
                        if (compoundNodesMap.containsKey(parentKey)) {
                            parentContents = (LinkedList)compoundNodesMap.get(parentKey);
                        } else {
                            parentContents = new LinkedList();
                            compoundNodesMap.put(parentKey, parentContents);
                            compoundNodesMapKeys.add(parentKey);
                        }
                        parentContents.add(aggregatedNodeGroup);
                        LinkedList parentList = (LinkedList)compoundNodesPerDepthLevel.get(parentKey.getProperty(Properties.DEPTH));
                        if (parentList.contains(parentKey)) continue;
                        parentList.add(parentKey);
                        continue;
                    }
                    this.applyNodeGroupOrderingToNodeArray(compoundContent, layer);
                }
            }
        }
        return totalEdges;
    }

    private void applyNodeGroupOrderingToNodeArray(List<NodeGroup> nodeGroups, LNode[] freeLayer) {
        int index = 0;
        for (NodeGroup nodeGroup : nodeGroups) {
            for (LNode node : nodeGroup.getNodes()) {
                freeLayer[index++] = node;
            }
        }
    }
}

