/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import com.google.common.collect.Multimap;
import de.cau.cs.kieler.kiml.options.PortType;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p3order.ForsterConstraintResolver;
import de.cau.cs.kieler.klay.layered.p3order.ICrossingMinimizationHeuristic;
import de.cau.cs.kieler.klay.layered.p3order.IPortDistributor;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarycenterHeuristic
implements ICrossingMinimizationHeuristic {
    private IPortDistributor portDistributor;
    private Random random;

    public BarycenterHeuristic(IPortDistributor selPortDistributor, Random graphRandom) {
        this.portDistributor = selPortDistributor;
        this.random = graphRandom;
    }

    @Override
    public int minimizeCrossings(List<NodeGroup> layerNodeGroups, Multimap<LNode, LNode> layoutUnits, int layerIndex, boolean preOrdered, boolean randomize, boolean forward, float[] portPos, Map<LNode, NodeGroup>[] singleNodeNodeGroups) {
        if (layerNodeGroups.isEmpty()) {
            return 0;
        }
        int totalEdges = 0;
        if (randomize) {
            this.randomizeBarycenters(layerNodeGroups);
        } else {
            totalEdges = this.calculateBarycenters(layerNodeGroups, singleNodeNodeGroups[layerIndex], forward, portPos);
            this.fillInUnknownBarycenters(layerNodeGroups, preOrdered);
        }
        Collections.sort(layerNodeGroups);
        ForsterConstraintResolver constraintResolver = new ForsterConstraintResolver();
        constraintResolver.processConstraints(layerNodeGroups, layerIndex, this.random, singleNodeNodeGroups, layoutUnits);
        LinkedList<LNode> layerSingles = new LinkedList<LNode>();
        for (NodeGroup nodeGroup : layerNodeGroups) {
            List<LNode> nodeGroupNodes = nodeGroup.getNodes();
            if (nodeGroupNodes.size() != 1) continue;
            layerSingles.add(nodeGroupNodes.get(0));
        }
        LNode[] layerSingleNodes = new LNode[layerSingles.size()];
        int i = 0;
        while (i < layerSingles.size()) {
            layerSingleNodes[i] = (LNode)layerSingles.get(i);
            ++i;
        }
        this.portDistributor.calculatePortRanks(layerSingleNodes);
        return totalEdges;
    }

    private void randomizeBarycenters(List<NodeGroup> nodeGroups) {
        for (NodeGroup nodeGroup : nodeGroups) {
            if (nodeGroup.getNodes().size() >= 2) continue;
            nodeGroup.setBarycenter(this.random.nextFloat());
            nodeGroup.setSummedWeight(nodeGroup.getBarycenter());
            nodeGroup.setDegree(1);
        }
    }

    private void fillInUnknownBarycenters(List<NodeGroup> nodeGroups, boolean preOrdered) {
        if (preOrdered) {
            float lastValue = -1.0f;
            ListIterator<NodeGroup> nodeGroupIterator = nodeGroups.listIterator();
            while (nodeGroupIterator.hasNext()) {
                NodeGroup nodeGroup = nodeGroupIterator.next();
                float value = nodeGroup.getBarycenter();
                if (value < 0.0f) {
                    float nextValue = lastValue + 1.0f;
                    if (nodeGroupIterator.hasNext()) {
                        ListIterator<NodeGroup> nextNodeGroupIterator = nodeGroups.listIterator(nodeGroupIterator.nextIndex());
                        while (nextNodeGroupIterator.hasNext()) {
                            float x = ((NodeGroup)nextNodeGroupIterator.next()).getBarycenter();
                            if (!(x >= 0.0f)) continue;
                            nextValue = x;
                            break;
                        }
                    }
                    value = (lastValue + nextValue) / 2.0f;
                    nodeGroup.setBarycenter(value);
                }
                lastValue = value;
            }
        } else {
            float maxBary = 0.0f;
            for (NodeGroup nodeGroup : nodeGroups) {
                maxBary = Math.max(maxBary, nodeGroup.getBarycenter());
            }
            maxBary += 2.0f;
            for (NodeGroup vertex : nodeGroups) {
                if (!(vertex.getBarycenter() < 0.0f)) continue;
                vertex.setBarycenter(this.random.nextFloat() * maxBary - 1.0f);
            }
        }
    }

    private int calculateBarycenters(List<NodeGroup> nodeGroups, Map<LNode, NodeGroup> layerNodeGroups, boolean forward, float[] portPos) {
        HashSet<NodeGroup> workingSet = new HashSet<NodeGroup>();
        int totalEdges = 0;
        for (NodeGroup nodeGroup : nodeGroups) {
            if (nodeGroup.getNodes().size() < 2) {
                this.calculateBarycenter(nodeGroup, layerNodeGroups, forward, workingSet, portPos);
            }
            totalEdges += nodeGroup.getDegree();
        }
        return totalEdges;
    }

    private void calculateBarycenter(NodeGroup nodeGroup, Map<LNode, NodeGroup> layerNodeGroups, boolean forward, Set<NodeGroup> workingSet, float[] portPos) {
        if (workingSet.contains(nodeGroup)) {
            return;
        }
        workingSet.add(nodeGroup);
        nodeGroup.setDegree(0);
        nodeGroup.setSummedWeight(0.0f);
        nodeGroup.setBarycenter(-1.0f);
        LNode node = nodeGroup.getNodes().get(0);
        for (LPort freePort : node.getPorts(forward ? PortType.INPUT : PortType.OUTPUT)) {
            for (LPort fixedPort : freePort.getConnectedPorts()) {
                LNode fixedNode = fixedPort.getNode();
                if (fixedNode.getLayer() == node.getLayer()) {
                    NodeGroup fixedNodeGroup = layerNodeGroups.get(fixedNode);
                    this.calculateBarycenter(fixedNodeGroup, layerNodeGroups, forward, workingSet, portPos);
                    nodeGroup.setDegree(nodeGroup.getDegree() + Math.max(0, fixedNodeGroup.getDegree() - 1));
                    nodeGroup.setSummedWeight(nodeGroup.getSummedWeight() + fixedNodeGroup.getSummedWeight());
                    continue;
                }
                nodeGroup.setSummedWeight(nodeGroup.getSummedWeight() + portPos[fixedPort.id]);
            }
            nodeGroup.setDegree(nodeGroup.getDegree() + freePort.getDegree());
        }
        List<LNode> barycenterAssociates = node.getProperty(Properties.BARYCENTER_ASSOCIATES);
        if (barycenterAssociates != null) {
            for (LNode associate : barycenterAssociates) {
                if (node.getLayer() != associate.getLayer()) continue;
                NodeGroup associateVertex = layerNodeGroups.get(associate);
                this.calculateBarycenter(associateVertex, layerNodeGroups, forward, workingSet, portPos);
                nodeGroup.setDegree(nodeGroup.getDegree() + Math.max(0, associateVertex.getDegree()));
                nodeGroup.setSummedWeight(nodeGroup.getSummedWeight() + associateVertex.getSummedWeight());
            }
        }
        if (nodeGroup.getDegree() > 0) {
            nodeGroup.setBarycenter(nodeGroup.getSummedWeight() / (float)nodeGroup.getDegree());
        }
    }
}

