/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p2layers;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingStrategy;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.intermediate.IntermediateLayoutProcessor;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.EnumSet;
import java.util.List;

public class LongestPathLayerer
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final IntermediateProcessingStrategy BASELINE_PROCESSING_STRATEGY = new IntermediateProcessingStrategy(EnumSet.of(IntermediateLayoutProcessor.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER), null, EnumSet.of(IntermediateLayoutProcessor.LAYER_CONSTRAINT_PROCESSOR), null, null, null);
    private static final IntermediateProcessingStrategy BIG_NODES_PROCESSING_ADDITIONS = new IntermediateProcessingStrategy(1, IntermediateLayoutProcessor.BIG_NODES_PROCESSOR);
    private LayeredGraph layeredGraph;
    private int[] nodeHeights;

    public IntermediateProcessingStrategy getIntermediateProcessingStrategy(LayeredGraph graph) {
        IntermediateProcessingStrategy strategy = new IntermediateProcessingStrategy(BASELINE_PROCESSING_STRATEGY);
        if (graph.getProperty(Properties.DISTRIBUTE_NODES).booleanValue()) {
            strategy.addAll(BIG_NODES_PROCESSING_ADDITIONS);
        }
        return strategy;
    }

    public void process(LayeredGraph thelayeredGraph) {
        this.getMonitor().begin("Longest path layering", 1.0f);
        this.layeredGraph = thelayeredGraph;
        List<LNode> nodes = this.layeredGraph.getLayerlessNodes();
        this.nodeHeights = new int[nodes.size()];
        int index = 0;
        for (LNode node : nodes) {
            node.id = index;
            this.nodeHeights[index] = -1;
            ++index;
        }
        for (LNode node : nodes) {
            this.visit(node);
        }
        nodes.clear();
        this.layeredGraph = null;
        this.nodeHeights = null;
        this.getMonitor().done();
    }

    private int visit(LNode node) {
        int height = this.nodeHeights[node.id];
        if (height >= 0) {
            return height;
        }
        int maxHeight = 1;
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getOutgoingEdges()) {
                LNode targetNode = edge.getTarget().getNode();
                if (edge.getSource().getNode() == targetNode) continue;
                int targetHeight = this.visit(targetNode) + 1;
                maxHeight = Math.max(maxHeight, targetHeight);
            }
        }
        this.putNode(node, maxHeight);
        return maxHeight;
    }

    private void putNode(LNode node, int height) {
        List<Layer> layers = this.layeredGraph.getLayers();
        int i = layers.size();
        while (i < height) {
            layers.add(0, new Layer(this.layeredGraph));
            ++i;
        }
        node.setLayer(layers.get(layers.size() - height));
        this.nodeHeights[node.id] = height;
    }
}

