/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p2layers;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.PortType;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingStrategy;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class InteractiveLayerer
extends AbstractAlgorithm
implements ILayoutPhase {
    public IntermediateProcessingStrategy getIntermediateProcessingStrategy(LayeredGraph graph) {
        return null;
    }

    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Interactive node layering", 1.0f);
        LinkedList currentSpans = new LinkedList();
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            double minx = node.getPosition().x;
            double maxx = minx + node.getSize().x;
            ListIterator<LayerSpan> spanIter = currentSpans.listIterator();
            LayerSpan foundSpan = null;
            while (spanIter.hasNext()) {
                LayerSpan span = (LayerSpan)spanIter.next();
                if (span.start >= maxx) {
                    spanIter.previous();
                    break;
                }
                if (!(span.end > minx)) continue;
                if (foundSpan == null) {
                    span.nodes.add(node);
                    span.start = Math.min(span.start, minx);
                    span.end = Math.max(span.end, maxx);
                    foundSpan = span;
                    continue;
                }
                foundSpan.nodes.addAll(span.nodes);
                foundSpan.end = Math.max(foundSpan.end, span.end);
                spanIter.remove();
            }
            if (foundSpan != null) continue;
            foundSpan = new LayerSpan();
            foundSpan.start = minx;
            foundSpan.end = maxx;
            spanIter.add(foundSpan);
            foundSpan.nodes.add(node);
        }
        List<Layer> layers = layeredGraph.getLayers();
        int nextIndex = 0;
        for (LayerSpan span : currentSpans) {
            Layer layer = new Layer(layeredGraph);
            layer.id = nextIndex++;
            layers.add(layer);
            for (LNode node : span.nodes) {
                node.setLayer(layer);
                node.id = 0;
            }
        }
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.id != 0) continue;
            this.checkNode(node, layeredGraph);
        }
        while (layers.get(0).getNodes().isEmpty()) {
            layers.remove(0);
        }
        layeredGraph.getLayerlessNodes().clear();
        this.getMonitor().done();
    }

    private void checkNode(LNode node1, LayeredGraph graph) {
        node1.id = 1;
        Layer layer1 = node1.getLayer();
        for (LPort port : node1.getPorts(PortType.OUTPUT)) {
            for (LEdge edge : port.getOutgoingEdges()) {
                Layer newLayer;
                LNode node2 = edge.getTarget().getNode();
                if (node1 == node2) continue;
                Layer layer2 = node2.getLayer();
                if (layer2.id > layer1.id) continue;
                int newIndex = layer1.id + 1;
                if (newIndex == graph.getLayers().size()) {
                    newLayer = new Layer(graph);
                    newLayer.id = newIndex;
                    graph.getLayers().add(newLayer);
                    node2.setLayer(newLayer);
                } else {
                    newLayer = graph.getLayers().get(newIndex);
                    node2.setLayer(newLayer);
                }
                this.checkNode(node2, graph);
            }
        }
    }

    private class LayerSpan {
        private double start;
        private double end;
        private List<LNode> nodes = new LinkedList<LNode>();

        private LayerSpan() {
        }
    }
}

