/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;

public class SelfLoopProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Self-loop processing", 1.0f);
        LinkedList<LNode> createdDummies = new LinkedList<LNode>();
        for (Layer layer : layeredGraph) {
            createdDummies.clear();
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    LEdge[] edges;
                    LEdge[] lEdgeArray = edges = port.getOutgoingEdges().toArray(new LEdge[0]);
                    int n = edges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LEdge edge = lEdgeArray[n2];
                        if (edge.getSource().getNode() == edge.getTarget().getNode()) {
                            LPort sourcePort = edge.getSource();
                            LPort targetPort = edge.getTarget();
                            PortSide sourcePortSide = sourcePort.getSide();
                            PortSide targetPortSide = targetPort.getSide();
                            if ((sourcePortSide == PortSide.NORTH || sourcePortSide == PortSide.SOUTH) && targetPortSide == PortSide.WEST) {
                                edge.reverse(false);
                            } else if (sourcePortSide == PortSide.SOUTH && targetPortSide == PortSide.NORTH) {
                                edge.reverse(false);
                            } else if (sourcePortSide == PortSide.EAST && targetPortSide != PortSide.EAST) {
                                edge.reverse(false);
                            }
                            if (sourcePortSide == PortSide.EAST && targetPortSide == PortSide.WEST) {
                                createdDummies.add(this.createDummy(edge, targetPort, sourcePort));
                            } else if (sourcePortSide == PortSide.WEST && targetPortSide == PortSide.EAST) {
                                createdDummies.add(this.createDummy(edge, sourcePort, targetPort));
                            }
                        }
                        ++n2;
                    }
                }
            }
            for (LNode dummy : createdDummies) {
                dummy.setLayer(layer);
            }
        }
        this.getMonitor().done();
    }

    private LNode createDummy(LEdge edge, LPort sourcePort, LPort targetPort) {
        LNode dummyNode = new LNode();
        dummyNode.setProperty(Properties.ORIGIN, edge);
        dummyNode.setProperty(Properties.NODE_TYPE, (Object)NodeType.LONG_EDGE);
        dummyNode.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        LPort dummyInput = new LPort();
        dummyInput.setSide(PortSide.WEST);
        dummyInput.setNode(dummyNode);
        LPort dummyOutput = new LPort();
        dummyOutput.setSide(PortSide.EAST);
        dummyOutput.setNode(dummyNode);
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties(edge);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(targetPort);
        return dummyNode;
    }
}

