/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;

public class PortSideProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Port side processing", 1.0f);
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                if (node.getProperty(LayoutOptions.PORT_CONSTRAINTS).isSideFixed()) continue;
                this.distributePorts(node);
                node.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_SIDE);
            }
        }
        this.getMonitor().done();
    }

    private void distributePorts(LNode node) {
        for (LPort port : node.getPorts()) {
            port.setSide(port.getNetFlow() < 0 ? PortSide.EAST : PortSide.WEST);
        }
    }
}

