/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;

public class NorthSouthPortPostprocessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Odd port side processing", 1.0f);
        for (Layer layer : layeredGraph) {
            LNode[] nodeArray;
            LNode[] lNodeArray = nodeArray = layer.getNodes().toArray(new LNode[0]);
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                if (node.getProperty(Properties.NODE_TYPE) == NodeType.NORTH_SOUTH_PORT) {
                    if (node.getProperty(Properties.ORIGIN) instanceof LEdge) {
                        this.processSelfLoop(node);
                    } else {
                        for (LPort port : node.getPorts()) {
                            if (!port.getIncomingEdges().isEmpty()) {
                                this.processInputPort(port);
                            }
                            if (port.getOutgoingEdges().isEmpty()) continue;
                            this.processOutputPort(port);
                        }
                    }
                    node.setLayer(null);
                }
                ++n2;
            }
        }
        this.getMonitor().done();
    }

    private void processInputPort(LPort inputPort) {
        LEdge[] edgeArray;
        LPort originPort = (LPort)inputPort.getProperty(Properties.ORIGIN);
        KVector bendPoint = new KVector(inputPort.getNode().getPosition());
        bendPoint.x = originPort.getNode().getPosition().x + originPort.getPosition().x;
        LEdge[] lEdgeArray = edgeArray = inputPort.getIncomingEdges().toArray(new LEdge[0]);
        int n = edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge inEdge = lEdgeArray[n2];
            inEdge.setTarget(originPort);
            inEdge.getBendPoints().add(bendPoint);
            ++n2;
        }
    }

    private void processOutputPort(LPort outputPort) {
        LEdge[] edgeArray;
        LPort originPort = (LPort)outputPort.getProperty(Properties.ORIGIN);
        KVector bendPoint = new KVector(outputPort.getNode().getPosition());
        bendPoint.x = originPort.getNode().getPosition().x + originPort.getPosition().x;
        LEdge[] lEdgeArray = edgeArray = outputPort.getOutgoingEdges().toArray(new LEdge[0]);
        int n = edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge outEdge = lEdgeArray[n2];
            outEdge.setSource(originPort);
            outEdge.getBendPoints().addFirst(bendPoint);
            ++n2;
        }
    }

    private void processSelfLoop(LNode dummy) {
        LEdge selfLoop = (LEdge)dummy.getProperty(Properties.ORIGIN);
        LPort inputPort = dummy.getPorts(PortSide.WEST).iterator().next();
        LPort outputPort = dummy.getPorts(PortSide.EAST).iterator().next();
        LPort originInputPort = (LPort)inputPort.getProperty(Properties.ORIGIN);
        LPort originOutputPort = (LPort)outputPort.getProperty(Properties.ORIGIN);
        selfLoop.setSource(originOutputPort);
        selfLoop.setTarget(originInputPort);
        KVector bendPoint = new KVector(outputPort.getNode().getPosition());
        bendPoint.x = originOutputPort.getNode().getPosition().x + originOutputPort.getPosition().x;
        selfLoop.getBendPoints().add(bendPoint);
        bendPoint = new KVector(inputPort.getNode().getPosition());
        bendPoint.x = originInputPort.getNode().getPosition().x + originInputPort.getPosition().x;
        selfLoop.getBendPoints().add(bendPoint);
    }
}

