/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.List;
import java.util.ListIterator;

public class LongEdgeJoiner
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Edge joining", 1.0f);
        for (Layer layer : layeredGraph) {
            ListIterator<LNode> nodeIterator = layer.getNodes().listIterator();
            while (nodeIterator.hasNext()) {
                LNode node = nodeIterator.next();
                if (!node.getProperty(Properties.NODE_TYPE).equals((Object)NodeType.LONG_EDGE)) continue;
                List<LEdge> inputPortEdges = node.getPorts(PortSide.WEST).iterator().next().getIncomingEdges();
                List<LEdge> outputPortEdges = node.getPorts(PortSide.EAST).iterator().next().getOutgoingEdges();
                int edgeCount = inputPortEdges.size();
                while (edgeCount-- > 0) {
                    LEdge survivingEdge = inputPortEdges.get(0);
                    LEdge droppedEdge = outputPortEdges.get(0);
                    survivingEdge.setTarget(droppedEdge.getTarget());
                    droppedEdge.setSource(null);
                    droppedEdge.setTarget(null);
                    KVectorChain survivingBendPoints = survivingEdge.getBendPoints();
                    for (KVector bendPoint : droppedEdge.getBendPoints()) {
                        survivingBendPoints.add(new KVector(bendPoint));
                    }
                }
                nodeIterator.remove();
            }
        }
        this.getMonitor().done();
    }
}

