/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.BigNodesProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.CommentPostprocessor;
import de.cau.cs.kieler.klay.layered.intermediate.CommentPreprocessor;
import de.cau.cs.kieler.klay.layered.intermediate.CompoundCycleProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.CompoundDummyEdgeRemover;
import de.cau.cs.kieler.klay.layered.intermediate.CompoundGraphRestorer;
import de.cau.cs.kieler.klay.layered.intermediate.CompoundSideProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.EdgeAndLayerConstraintEdgeReverser;
import de.cau.cs.kieler.klay.layered.intermediate.GraphTransformer;
import de.cau.cs.kieler.klay.layered.intermediate.HierarchicalPortConstraintProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.HierarchicalPortDummySizeProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.HierarchicalPortOrthogonalEdgeRouter;
import de.cau.cs.kieler.klay.layered.intermediate.HierarchicalPortPositionProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.HyperedgeDummyMerger;
import de.cau.cs.kieler.klay.layered.intermediate.HypernodesProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.InLayerConstraintProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.InvertedPortProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.LayerConstraintProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.LongEdgeJoiner;
import de.cau.cs.kieler.klay.layered.intermediate.LongEdgeSplitter;
import de.cau.cs.kieler.klay.layered.intermediate.NodeMarginCalculator;
import de.cau.cs.kieler.klay.layered.intermediate.NorthSouthPortPostprocessor;
import de.cau.cs.kieler.klay.layered.intermediate.NorthSouthPortPreprocessor;
import de.cau.cs.kieler.klay.layered.intermediate.PortListSorter;
import de.cau.cs.kieler.klay.layered.intermediate.PortPositionProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.PortSideProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.ReversedEdgeRestorer;
import de.cau.cs.kieler.klay.layered.intermediate.SelfLoopProcessor;
import de.cau.cs.kieler.klay.layered.intermediate.SubgraphOrderingProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IntermediateLayoutProcessor {
    COMPOUND_CYCLE_PROCESSOR,
    LEFT_DIR_PREPROCESSOR,
    DOWN_DIR_PREPROCESSOR,
    UP_DIR_PREPROCESSOR,
    COMMENT_PREPROCESSOR,
    EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER,
    BIG_NODES_PROCESSOR,
    LAYER_CONSTRAINT_PROCESSOR,
    HIERARCHICAL_PORT_CONSTRAINT_PROCESSOR,
    COMPOUND_DUMMY_EDGE_REMOVER,
    LONG_EDGE_SPLITTER,
    PORT_SIDE_PROCESSOR,
    INVERTED_PORT_PROCESSOR,
    SELF_LOOP_PROCESSOR,
    PORT_LIST_SORTER,
    NORTH_SOUTH_PORT_PREPROCESSOR,
    SUBGRAPH_ORDERING_PROCESSOR,
    IN_LAYER_CONSTRAINT_PROCESSOR,
    HYPEREDGE_DUMMY_MERGER,
    PORT_POSITION_PROCESSOR,
    NODE_MARGIN_CALCULATOR,
    COMPOUND_SIDE_PROCESSOR,
    HIERARCHICAL_PORT_DUMMY_SIZE_PROCESSOR,
    HIERARCHICAL_PORT_POSITION_PROCESSOR,
    COMMENT_POSTPROCESSOR,
    HYPERNODE_PROCESSOR,
    HIERARCHICAL_PORT_ORTHOGONAL_EDGE_ROUTER,
    LONG_EDGE_JOINER,
    NORTH_SOUTH_PORT_POSTPROCESSOR,
    REVERSED_EDGE_RESTORER,
    COMPOUND_GRAPH_RESTORER,
    LEFT_DIR_POSTPROCESSOR,
    DOWN_DIR_POSTPROCESSOR,
    UP_DIR_POSTPROCESSOR;


    public ILayoutProcessor create() {
        switch (this) {
            case BIG_NODES_PROCESSOR: {
                return new BigNodesProcessor();
            }
            case COMMENT_POSTPROCESSOR: {
                return new CommentPostprocessor();
            }
            case COMMENT_PREPROCESSOR: {
                return new CommentPreprocessor();
            }
            case COMPOUND_CYCLE_PROCESSOR: {
                return new CompoundCycleProcessor();
            }
            case COMPOUND_DUMMY_EDGE_REMOVER: {
                return new CompoundDummyEdgeRemover();
            }
            case COMPOUND_GRAPH_RESTORER: {
                return new CompoundGraphRestorer();
            }
            case COMPOUND_SIDE_PROCESSOR: {
                return new CompoundSideProcessor();
            }
            case DOWN_DIR_PREPROCESSOR: 
            case DOWN_DIR_POSTPROCESSOR: {
                return new GraphTransformer(GraphTransformer.Mode.TRANSPOSE);
            }
            case HIERARCHICAL_PORT_CONSTRAINT_PROCESSOR: {
                return new HierarchicalPortConstraintProcessor();
            }
            case HIERARCHICAL_PORT_DUMMY_SIZE_PROCESSOR: {
                return new HierarchicalPortDummySizeProcessor();
            }
            case HIERARCHICAL_PORT_ORTHOGONAL_EDGE_ROUTER: {
                return new HierarchicalPortOrthogonalEdgeRouter();
            }
            case HIERARCHICAL_PORT_POSITION_PROCESSOR: {
                return new HierarchicalPortPositionProcessor();
            }
            case HYPEREDGE_DUMMY_MERGER: {
                return new HyperedgeDummyMerger();
            }
            case HYPERNODE_PROCESSOR: {
                return new HypernodesProcessor();
            }
            case IN_LAYER_CONSTRAINT_PROCESSOR: {
                return new InLayerConstraintProcessor();
            }
            case LAYER_CONSTRAINT_PROCESSOR: {
                return new LayerConstraintProcessor();
            }
            case LEFT_DIR_PREPROCESSOR: 
            case LEFT_DIR_POSTPROCESSOR: {
                return new GraphTransformer(GraphTransformer.Mode.MIRROR);
            }
            case EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER: {
                return new EdgeAndLayerConstraintEdgeReverser();
            }
            case LONG_EDGE_JOINER: {
                return new LongEdgeJoiner();
            }
            case LONG_EDGE_SPLITTER: {
                return new LongEdgeSplitter();
            }
            case NODE_MARGIN_CALCULATOR: {
                return new NodeMarginCalculator();
            }
            case NORTH_SOUTH_PORT_POSTPROCESSOR: {
                return new NorthSouthPortPostprocessor();
            }
            case NORTH_SOUTH_PORT_PREPROCESSOR: {
                return new NorthSouthPortPreprocessor();
            }
            case INVERTED_PORT_PROCESSOR: {
                return new InvertedPortProcessor();
            }
            case PORT_LIST_SORTER: {
                return new PortListSorter();
            }
            case PORT_POSITION_PROCESSOR: {
                return new PortPositionProcessor();
            }
            case PORT_SIDE_PROCESSOR: {
                return new PortSideProcessor();
            }
            case REVERSED_EDGE_RESTORER: {
                return new ReversedEdgeRestorer();
            }
            case SELF_LOOP_PROCESSOR: {
                return new SelfLoopProcessor();
            }
            case SUBGRAPH_ORDERING_PROCESSOR: {
                return new SubgraphOrderingProcessor();
            }
            case UP_DIR_PREPROCESSOR: 
            case UP_DIR_POSTPROCESSOR: {
                return new GraphTransformer(GraphTransformer.Mode.MIRROR_AND_TRANSPOSE);
            }
        }
        return null;
    }

    public static IntermediateLayoutProcessor valueOf(String string) {
        return Enum.valueOf(IntermediateLayoutProcessor.class, string);
    }
}

