/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.InLayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;

public class InLayerConstraintProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Layer constraint edge reversal", 1.0f);
        for (Layer layer : layeredGraph) {
            int topInsertionIndex = -1;
            LinkedList<LNode> bottomConstrainedNodes = new LinkedList<LNode>();
            LNode[] nodes = layer.getNodes().toArray(new LNode[0]);
            int i = 0;
            while (i < nodes.length) {
                InLayerConstraint constraint = nodes[i].getProperty(Properties.IN_LAYER_CONSTRAINT);
                if (topInsertionIndex == -1) {
                    if (constraint != InLayerConstraint.TOP) {
                        topInsertionIndex = i;
                    }
                } else if (constraint == InLayerConstraint.TOP) {
                    nodes[i].setLayer(null);
                    nodes[i].setLayer(topInsertionIndex++, layer);
                }
                if (constraint == InLayerConstraint.BOTTOM) {
                    bottomConstrainedNodes.add(nodes[i]);
                }
                ++i;
            }
            for (LNode node : bottomConstrainedNodes) {
                node.setLayer(null);
                node.setLayer(layer);
            }
        }
        this.getMonitor().done();
    }
}

