/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.List;

public class HierarchicalPortPositionProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Hierarchical port position processing", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        if (!layers.isEmpty()) {
            this.fixCoordinates(layers.get(0), layeredGraph);
            this.fixCoordinates(layers.get(layers.size() - 1), layeredGraph);
        }
        this.getMonitor().done();
    }

    private void fixCoordinates(Layer layer, LayeredGraph layeredGraph) {
        PortConstraints portConstraints = layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        if (!portConstraints.isRatioFixed() && !portConstraints.isPosFixed()) {
            return;
        }
        double graphHeight = layeredGraph.getActualSize().y;
        for (LNode node : layer) {
            if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT) continue;
            double finalYCoordinate = node.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION);
            if (portConstraints == PortConstraints.FIXED_RATIO) {
                finalYCoordinate *= graphHeight;
            }
            node.getPosition().y = finalYCoordinate;
            node.borderToContentAreaCoordinates(false, true);
        }
    }
}

