/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.p5edges.OrthogonalRoutingGenerator;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalPortOrthogonalEdgeRouter
extends AbstractAlgorithm
implements ILayoutProcessor {
    @Override
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Orthogonally routing hierarchical port edges", 1.0f);
        Set<LNode> northSouthDummies = this.restoreNorthSouthDummies(layeredGraph);
        this.setNorthSouthDummyCoordinates(layeredGraph, northSouthDummies);
        this.routeEdges(layeredGraph, northSouthDummies);
        this.removeTemporaryNorthSouthDummies(layeredGraph);
        this.fixCoordinates(layeredGraph);
        this.correctSlantedEdgeSegments(layeredGraph);
        this.getMonitor().done();
    }

    private Set<LNode> restoreNorthSouthDummies(LayeredGraph layeredGraph) {
        HashSet<LNode> restoredDummies = new HashSet<LNode>();
        Layer lastLayer = null;
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                LNode replacedDummy;
                if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT || node.getProperty(Properties.EXT_PORT_REPLACED_DUMMY) == null || (replacedDummy = node.getProperty(Properties.EXT_PORT_REPLACED_DUMMY)).getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT) continue;
                this.restoreDummy(replacedDummy, restoredDummies);
                this.connectNodeToDummy(node, replacedDummy);
            }
            lastLayer = layer;
        }
        for (LNode dummy : restoredDummies) {
            dummy.setLayer(lastLayer);
        }
        return restoredDummies;
    }

    private void restoreDummy(LNode dummy, Set<LNode> restoredDummies) {
        if (restoredDummies.contains(dummy)) {
            return;
        }
        PortSide portSide = dummy.getProperty(Properties.EXT_PORT_SIDE);
        LPort dummyPort = dummy.getPorts().get(0);
        if (portSide == PortSide.NORTH) {
            dummyPort.setSide(PortSide.SOUTH);
        } else if (portSide == PortSide.SOUTH) {
            dummyPort.setSide(PortSide.NORTH);
        }
        restoredDummies.add(dummy);
    }

    private void connectNodeToDummy(LNode node, LNode dummy) {
        LPort outPort = new LPort();
        outPort.setNode(node);
        PortSide extPortSide = node.getProperty(Properties.EXT_PORT_SIDE);
        outPort.setSide(extPortSide);
        LPort inPort = dummy.getPorts().get(0);
        LEdge edge = new LEdge();
        edge.setSource(outPort);
        edge.setTarget(inPort);
    }

    private void setNorthSouthDummyCoordinates(LayeredGraph layeredGraph, Set<LNode> northSouthDummies) {
        PortConstraints constraints = layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        KVector graphSize = layeredGraph.getSize();
        LInsets.Double graphInsets = layeredGraph.getInsets();
        float borderSpacing = layeredGraph.getProperty(Properties.BORDER_SPACING).floatValue();
        double graphWidth = graphSize.x + graphInsets.left + graphInsets.right + (double)(2.0f * borderSpacing);
        double northY = 0.0 - graphInsets.top - (double)borderSpacing - layeredGraph.getOffset().y;
        double southY = graphSize.y + graphInsets.top + graphInsets.bottom + (double)(2.0f * borderSpacing) + layeredGraph.getOffset().y;
        LinkedList<LNode> northernDummies = new LinkedList<LNode>();
        LinkedList<LNode> southernDummies = new LinkedList<LNode>();
        for (LNode dummy : northSouthDummies) {
            switch (constraints) {
                case FREE: 
                case FIXED_SIDE: {
                    this.calculateNorthSouthDummyPositions(dummy);
                    break;
                }
                case FIXED_ORDER: {
                    this.calculateNorthSouthDummyPositions(dummy);
                    break;
                }
                case FIXED_RATIO: {
                    this.applyNorthSouthDummyRatio(dummy, graphWidth);
                    dummy.borderToContentAreaCoordinates(true, false);
                    break;
                }
                case FIXED_POS: {
                    this.applyNorthSouthDummyPosition(dummy);
                    dummy.borderToContentAreaCoordinates(true, false);
                    graphSize.x = Math.max(graphSize.x, dummy.getPosition().x + dummy.getSize().x / 2.0);
                }
            }
            switch (dummy.getProperty(Properties.EXT_PORT_SIDE)) {
                case NORTH: {
                    dummy.getPosition().y = northY;
                    northernDummies.add(dummy);
                    break;
                }
                case SOUTH: {
                    dummy.getPosition().y = southY;
                    southernDummies.add(dummy);
                }
            }
        }
        switch (constraints) {
            case FREE: 
            case FIXED_SIDE: {
                this.ensureUniquePositions(northernDummies, layeredGraph);
                this.ensureUniquePositions(southernDummies, layeredGraph);
                break;
            }
            case FIXED_ORDER: {
                this.restoreProperOrder(northernDummies, layeredGraph);
                this.restoreProperOrder(southernDummies, layeredGraph);
            }
        }
    }

    private void calculateNorthSouthDummyPositions(LNode dummy) {
        LPort dummyInPort = dummy.getPorts().get(0);
        double posSum = 0.0;
        for (LPort connectedPort : dummyInPort.getConnectedPorts()) {
            posSum += connectedPort.getPosition().x + connectedPort.getNode().getPosition().x;
        }
        dummy.getPosition().x = posSum / (double)dummyInPort.getDegree() - dummy.getSize().x / 2.0;
    }

    private void applyNorthSouthDummyRatio(LNode dummy, double width) {
        dummy.getPosition().x = width * dummy.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION) - dummy.getSize().x / 2.0;
    }

    private void applyNorthSouthDummyPosition(LNode dummy) {
        dummy.getPosition().x = dummy.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION) - dummy.getSize().x / 2.0;
    }

    private void ensureUniquePositions(List<LNode> dummies, LayeredGraph graph) {
        if (dummies.isEmpty()) {
            return;
        }
        LNode[] dummyArray = dummies.toArray(new LNode[dummies.size()]);
        Arrays.sort(dummyArray, new Comparator<LNode>(){

            @Override
            public int compare(LNode a, LNode b) {
                double diff = a.getPosition().x - b.getPosition().x;
                if (diff < 0.0) {
                    return -1;
                }
                if (diff > 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        this.assignAscendingCoordinates(dummyArray, graph);
    }

    private void restoreProperOrder(List<LNode> dummies, LayeredGraph graph) {
        if (dummies.isEmpty()) {
            return;
        }
        LNode[] dummyArray = dummies.toArray(new LNode[dummies.size()]);
        Arrays.sort(dummyArray, new Comparator<LNode>(){

            @Override
            public int compare(LNode a, LNode b) {
                double diff = a.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION) - b.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION);
                if (diff < 0.0) {
                    return -1;
                }
                if (diff > 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        this.assignAscendingCoordinates(dummyArray, graph);
    }

    private void assignAscendingCoordinates(LNode[] dummies, LayeredGraph graph) {
        float edgeSpacing = graph.getProperty(Properties.OBJ_SPACING).floatValue() * graph.getProperty(Properties.EDGE_SPACING_FACTOR).floatValue();
        double lastCoordinate = dummies[0].getPosition().x + dummies[0].getSize().x;
        int index = 1;
        while (index < dummies.length) {
            KVector currentPosition = dummies[index].getPosition();
            KVector currentSize = dummies[index].getSize();
            if (currentPosition.x <= lastCoordinate + (double)edgeSpacing) {
                currentPosition.x = lastCoordinate + (double)edgeSpacing;
            }
            lastCoordinate = currentPosition.x + currentSize.x;
            ++index;
        }
    }

    private void routeEdges(LayeredGraph layeredGraph, Iterable<LNode> northSouthDummies) {
        OrthogonalRoutingGenerator routingGenerator;
        int slots;
        HashSet<LNode> northernSourceLayer = new HashSet<LNode>();
        HashSet<LNode> northernTargetLayer = new HashSet<LNode>();
        HashSet<LNode> southernSourceLayer = new HashSet<LNode>();
        HashSet<LNode> southernTargetLayer = new HashSet<LNode>();
        double nodeSpacing = layeredGraph.getProperty(Properties.OBJ_SPACING).floatValue();
        double edgeSpacing = nodeSpacing * (double)layeredGraph.getProperty(Properties.EDGE_SPACING_FACTOR).floatValue();
        boolean debug = layeredGraph.getProperty(LayoutOptions.DEBUG_MODE);
        for (LNode hierarchicalPortDummy : northSouthDummies) {
            PortSide portSide = hierarchicalPortDummy.getProperty(Properties.EXT_PORT_SIDE);
            if (portSide == PortSide.NORTH) {
                northernTargetLayer.add(hierarchicalPortDummy);
                for (LEdge edge : hierarchicalPortDummy.getIncomingEdges()) {
                    northernSourceLayer.add(edge.getSource().getNode());
                }
                continue;
            }
            if (portSide != PortSide.SOUTH) continue;
            southernTargetLayer.add(hierarchicalPortDummy);
            for (LEdge edge : hierarchicalPortDummy.getIncomingEdges()) {
                southernSourceLayer.add(edge.getSource().getNode());
            }
        }
        if (!northernSourceLayer.isEmpty() && (slots = (routingGenerator = new OrthogonalRoutingGenerator(new OrthogonalRoutingGenerator.SouthToNorthRoutingStrategy(), edgeSpacing, debug ? "extnorth" : null)).routeEdges(layeredGraph, northernSourceLayer, 0, northernTargetLayer, -nodeSpacing)) > 0) {
            layeredGraph.getOffset().y += nodeSpacing + (double)(slots - 1) * edgeSpacing;
            layeredGraph.getSize().y += layeredGraph.getOffset().y;
        }
        if (!southernSourceLayer.isEmpty() && (slots = (routingGenerator = new OrthogonalRoutingGenerator(new OrthogonalRoutingGenerator.NorthToSouthRoutingStrategy(), edgeSpacing, debug ? "extsouth" : null)).routeEdges(layeredGraph, southernSourceLayer, 0, southernTargetLayer, layeredGraph.getSize().y + nodeSpacing)) > 0) {
            layeredGraph.getSize().y += nodeSpacing + (double)(slots - 1) * edgeSpacing;
        }
    }

    private void removeTemporaryNorthSouthDummies(LayeredGraph layeredGraph) {
        LinkedList<LNode> nodesToRemove = new LinkedList<LNode>();
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                LEdge[] edges;
                if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT || node.getProperty(Properties.EXT_PORT_REPLACED_DUMMY) == null) continue;
                LPort nodeInPort = node.getPorts().get(0);
                LPort nodeOutPort = node.getPorts().get(1);
                LEdge nodeToOriginEdge = nodeOutPort.getOutgoingEdges().get(0);
                KVectorChain bendPoints = new KVectorChain();
                KVector firstBendPoint = new KVector(nodeInPort.getPosition());
                firstBendPoint.add(node.getPosition());
                bendPoints.add(firstBendPoint);
                bendPoints.addAll(nodeToOriginEdge.getBendPoints());
                LNode replacedDummy = node.getProperty(Properties.EXT_PORT_REPLACED_DUMMY);
                LPort replacedDummyPort = replacedDummy.getPorts().get(0);
                LEdge[] lEdgeArray = edges = nodeInPort.getIncomingEdges().toArray(new LEdge[0]);
                int n = edges.length;
                int n2 = 0;
                while (n2 < n) {
                    LEdge edge = lEdgeArray[n2];
                    edge.setTarget(replacedDummyPort);
                    edge.getBendPoints().addAll(bendPoints);
                    ++n2;
                }
                nodeToOriginEdge.setSource(null);
                nodeToOriginEdge.setTarget(null);
                nodesToRemove.add(node);
            }
        }
        for (LNode node : nodesToRemove) {
            node.setLayer(null);
        }
    }

    private void fixCoordinates(LayeredGraph layeredGraph) {
        PortConstraints constraints = layeredGraph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        List<Layer> layers = layeredGraph.getLayers();
        this.fixCoordinates(layers.get(0), constraints, layeredGraph);
        this.fixCoordinates(layers.get(layers.size() - 1), constraints, layeredGraph);
    }

    private void fixCoordinates(Layer layer, PortConstraints constraints, LayeredGraph graph) {
        LInsets.Double insets = graph.getInsets();
        float borderSpacing = graph.getProperty(Properties.BORDER_SPACING).floatValue();
        KVector offset = graph.getOffset();
        KVector graphActualSize = graph.getActualSize();
        for (LNode node : layer) {
            if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT) continue;
            PortSide extPortSide = node.getProperty(Properties.EXT_PORT_SIDE);
            KVector nodePosition = node.getPosition();
            switch (extPortSide) {
                case EAST: {
                    nodePosition.x = graph.getSize().x + (double)borderSpacing + insets.right - offset.x;
                    break;
                }
                case WEST: {
                    nodePosition.x = -offset.x - (double)borderSpacing - insets.left;
                }
            }
            switch (extPortSide) {
                case EAST: 
                case WEST: {
                    if (constraints.isRatioFixed()) {
                        double ratio = node.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION);
                        nodePosition.y = graphActualSize.y * ratio;
                        node.borderToContentAreaCoordinates(false, true);
                        break;
                    }
                    if (!constraints.isPosFixed()) break;
                    nodePosition.y = node.getProperty(Properties.EXT_PORT_RATIO_OR_POSITION);
                    node.borderToContentAreaCoordinates(false, true);
                    break;
                }
                case NORTH: {
                    nodePosition.y = -offset.y - (double)borderSpacing - insets.top;
                    break;
                }
                case SOUTH: {
                    nodePosition.y = graph.getSize().y + (double)borderSpacing + insets.bottom - offset.y;
                }
            }
        }
    }

    private void correctSlantedEdgeSegments(LayeredGraph layeredGraph) {
        List<Layer> layers = layeredGraph.getLayers();
        this.correctSlantedEdgeSegments(layers.get(0));
        this.correctSlantedEdgeSegments(layers.get(layers.size() - 1));
    }

    private void correctSlantedEdgeSegments(Layer layer) {
        for (LNode node : layer) {
            PortSide extPortSide;
            if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT || (extPortSide = node.getProperty(Properties.EXT_PORT_SIDE)) != PortSide.EAST && extPortSide != PortSide.WEST) continue;
            for (LEdge edge : node.getConnectedEdges()) {
                KVectorChain bendPoints = edge.getBendPoints();
                if (bendPoints.isEmpty()) continue;
                LPort sourcePort = edge.getSource();
                KVector firstBendPoint = (KVector)bendPoints.getFirst();
                if (sourcePort.getNode() == node) {
                    firstBendPoint.y = node.getPosition().y + sourcePort.getPosition().y;
                }
                LPort targetPort = edge.getTarget();
                KVector lastBendPoint = (KVector)bendPoints.getLast();
                if (targetPort.getNode() != node) continue;
                lastBendPoint.y = node.getPosition().y + targetPort.getPosition().y;
            }
        }
    }
}

