/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.graph.LayeredGraph;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalPortDummySizeProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    @Override
    public void process(LayeredGraph layeredGraph) {
        this.getMonitor().begin("Hierarchical port dummy size processing", 1.0f);
        LinkedList<LNode> northernDummies = new LinkedList<LNode>();
        LinkedList<LNode> southernDummies = new LinkedList<LNode>();
        double normalSpacing = layeredGraph.getProperty(Properties.OBJ_SPACING).floatValue();
        double smallSpacing = normalSpacing * (double)layeredGraph.getProperty(Properties.EDGE_SPACING_FACTOR).floatValue();
        double delta = smallSpacing * 2.0;
        for (Layer layer : layeredGraph) {
            northernDummies.clear();
            southernDummies.clear();
            for (LNode node : layer) {
                if (node.getProperty(Properties.NODE_TYPE) != NodeType.EXTERNAL_PORT) continue;
                PortSide side = node.getProperty(Properties.EXT_PORT_SIDE);
                if (side == PortSide.NORTH) {
                    northernDummies.add(node);
                    continue;
                }
                if (side != PortSide.SOUTH) continue;
                southernDummies.add(node);
            }
            this.setWidths(northernDummies, true, delta);
            this.setWidths(southernDummies, false, delta);
        }
        this.getMonitor().done();
    }

    private void setWidths(List<LNode> nodes, boolean topDown, double delta) {
        double currentWidth = 0.0;
        double step = delta;
        if (!topDown) {
            currentWidth = delta * (double)(nodes.size() - 1);
            step *= -1.0;
        }
        for (LNode node : nodes) {
            node.getSize().x = currentWidth;
            currentWidth += step;
        }
    }
}

